/**
 * Description: CmCommentReport数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-14 上午 09:19:21
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import java.util.List;

import com.house365.beans.system.DomainObject;

import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmCommentReport数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
public class CmCommentReportEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 评论人ID
	 */
	
	private Integer criticId;
	
	/**
	 * 评论人名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String criticName;
	
	/**
     * 评论者手机号
     */
    @Length(max=20, message="长度需要大于0且小于20")
    private String criticPhone;
    
    /**
     * 评论来源 1:app 2:网站 3:触屏
     */
    private Integer source;
    
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * 图片集合
     */
    @Length(max=500, message="长度需要大于0且小于500")
    private String criticPictures;
    
    private List<String> picList;
    
    public List<String> getPicList() {
        return picList;
    }

    public void setPicList(List<String> picList) {
        this.picList = picList;
    }
	
	public String getCriticPhone() {
        return criticPhone;
    }

    public void setCriticPhone(String criticPhone) {
        this.criticPhone = criticPhone;
    }

    public String getCriticPictures() {
        return criticPictures;
    }

    public void setCriticPictures(String criticPictures) {
        this.criticPictures = criticPictures;
    }

    /**
	 * 评论人被举报次数
	 */
	
	private Integer criticReportedCount;
	
	/**
	 * 评论内容
	 */
	@Length(max=500, message="长度需要大于0且小于500")
	private String content;
	
	/**
     * 评论时间
     */
    
    private java.util.Date commentTime;
	
	public java.util.Date getCommentTime() {
        return commentTime;
    }

    public void setCommentTime(java.util.Date commentTime) {
        this.commentTime = commentTime;
    }
    
    /**
     * 解禁时间
     */
    private java.util.Date activateTime;
    
    public java.util.Date getActivateTime() {
        return activateTime;
    }

    public void setActivateTime(java.util.Date activateTime) {
        this.activateTime = activateTime;
    }

    /**
	 * 所属评论ID
	 */
	
	private Integer commentId;
	
	/**
	 * 所属评论类型 1:楼盘评论 2:楼盘评论回复 3.经纪人评论
	 */
	
	private Integer commentType;
	
	/**
	 * 累计举报人数
	 */
	
	private Integer reportCount;
	
	/**
	 * 举报原因
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String reportReason;
	
	/**
	 * 举报详细原因
	 */
	
	private Integer reportDetailReason;
	
	/**
	 * 创建时间
	 */
	
	private java.util.Date createTime;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
     * 城市key
     */
    @Length(max=20, message="长度需要大于0且小于20")
    private String cityKey;
    
    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }
	
	/**
	 * 是否删除 0:未 1:已
	 */
	
	private Integer isDeleted;
	
	/**
	 * 是否忽略 0:未 1:已
	 */
	
	private Integer isIgnored;
	
	//columns END
	/*
	public CmCommentReport(){
	}

	public CmCommentReport(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置评论人ID
	 * @param criticId 评论人ID
	 */
	public void setCriticId(Integer criticId) {
		this.criticId = criticId;
	}

	/**
	 * 获取评论人ID
	 * @return 评论人ID
	 */
	public Integer getCriticId() {
		return this.criticId;
	}

	/**
	 * 设置评论人名称
	 * @param criticName 评论人名称
	 */
	public void setCriticName(String criticName) {
		this.criticName = criticName;
	}

	/**
	 * 获取评论人名称
	 * @return 评论人名称
	 */
	public String getCriticName() {
		return this.criticName;
	}

	/**
	 * 设置评论人被举报次数
	 * @param criticReportedCount 评论人被举报次数
	 */
	public void setCriticReportedCount(Integer criticReportedCount) {
		this.criticReportedCount = criticReportedCount;
	}

	/**
	 * 获取评论人被举报次数
	 * @return 评论人被举报次数
	 */
	public Integer getCriticReportedCount() {
		return this.criticReportedCount;
	}

	/**
	 * 设置评论内容
	 * @param content 评论内容
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * 获取评论内容
	 * @return 评论内容
	 */
	public String getContent() {
		return this.content;
	}

	/**
	 * 设置所属评论ID
	 * @param commentId 所属评论ID
	 */
	public void setCommentId(Integer commentId) {
		this.commentId = commentId;
	}

	/**
	 * 获取所属评论ID
	 * @return 所属评论ID
	 */
	public Integer getCommentId() {
		return this.commentId;
	}

	/**
	 * 设置所属评论类型 0:楼盘评论 1:楼盘评论回复 2.经纪人评论
	 * @param commentType 所属评论类型 0:楼盘评论 1:楼盘评论回复 2.经纪人评论
	 */
	public void setCommentType(Integer commentType) {
		this.commentType = commentType;
	}

	/**
	 * 获取所属评论类型 0:楼盘评论 1:楼盘评论回复 2.经纪人评论
	 * @return 所属评论类型 0:楼盘评论 1:楼盘评论回复 2.经纪人评论
	 */
	public Integer getCommentType() {
		return this.commentType;
	}

	/**
	 * 设置累计举报人数
	 * @param reportCount 累计举报人数
	 */
	public void setReportCount(Integer reportCount) {
		this.reportCount = reportCount;
	}

	/**
	 * 获取累计举报人数
	 * @return 累计举报人数
	 */
	public Integer getReportCount() {
		return this.reportCount;
	}

	/**
	 * 设置举报原因
	 * @param reportReason 举报原因
	 */
	public void setReportReason(String reportReason) {
		this.reportReason = reportReason;
	}

	/**
	 * 获取举报原因
	 * @return 举报原因
	 */
	public String getReportReason() {
		return this.reportReason;
	}

	/**
	 * 设置举报详细原因
	 * @param reportDetailReason 举报详细原因
	 */
	public void setReportDetailReason(Integer reportDetailReason) {
		this.reportDetailReason = reportDetailReason;
	}

	/**
	 * 获取举报详细原因
	 * @return 举报详细原因
	 */
	public Integer getReportDetailReason() {
		return this.reportDetailReason;
	}

	/**
	 * 设置创建时间
	 * @param createTime 创建时间
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置创建时间字符串格式
	 * @param createTime 创建时间
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取创建时间
	 * @return 创建时间
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置是否删除 0:未 1:已
	 * @param isDeleted 是否删除 0:未 1:已
	 */
	public void setIsDeleted(Integer isDeleted) {
		this.isDeleted = isDeleted;
	}

	/**
	 * 获取是否删除 0:未 1:已
	 * @return 是否删除 0:未 1:已
	 */
	public Integer getIsDeleted() {
		return this.isDeleted;
	}

	/**
	 * 设置是否忽略 0:未 1:已
	 * @param isIgnored 是否忽略 0:未 1:已
	 */
	public void setIsIgnored(Integer isIgnored) {
		this.isIgnored = isIgnored;
	}

	/**
	 * 获取是否忽略 0:未 1:已
	 * @return 是否忽略 0:未 1:已
	 */
	public Integer getIsIgnored() {
		return this.isIgnored;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("CriticId",getCriticId())
			.append("CriticName",getCriticName())
			.append("CriticReportedCount",getCriticReportedCount())
			.append("Content",getContent())
			.append("CommentId",getCommentId())
			.append("CommentType",getCommentType())
			.append("ReportCount",getReportCount())
			.append("ReportReason",getReportReason())
			.append("ReportDetailReason",getReportDetailReason())
			.append("CreateTime",getCreateTime())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.append("IsDeleted",getIsDeleted())
			.append("IsIgnored",getIsIgnored())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmCommentReportEntity == false) return false;
		if(this == obj) return true;
		CmCommentReportEntity other = (CmCommentReportEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

