/**
 * Description: CmBroker数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 18:47:32
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmBroker数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmBrokerEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 经纪人编号
	 */
	
	private Integer brokerId;
	
	/**
	 * 经纪人名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String brokerName;
	
	/**
	 * 经纪人手机号
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String brokerPhone;
	
	/**
	 * 经纪人公司名称
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String brokerCompanyName;
	
	/**
	 * 总评论数
	 */
	
	private Integer totalCommetAmount;
	
	/**
	 * 5星星数量
	 */
	
	private Integer fiveStarAmount;
	
	/**
	 * 4星星数量
	 */
	
	private Integer fourStarAmount;
	
	/**
	 * 3星星数量
	 */
	
	private Integer threeStarAmount;
	
	/**
	 * 2星星数量
	 */
	
	private Integer twoStarAmount;
	
	/**
	 * 1星星数量
	 */
	
	private Integer oneStarAmount;
	
	/**
	 * 最早评论时间
	 */
	
	private java.util.Date earliestCommentTime;
	
	/**
	 * 标签编号-逗号分隔
	 */
	@Length(max=300, message="长度需要大于0且小于300")
	private String labels;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
     * 城市key
     */
    @Length(max=20, message="长度需要大于0且小于20")
    private String cityKey;
	
	public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    /**
	 * 是否删除
	 */
	
	private Integer isDeleted;
	
	//columns END
	/*
	public CmBroker(){
	}

	public CmBroker(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置经纪人编号
	 * @param brokerId 经纪人编号
	 */
	public void setBrokerId(Integer brokerId) {
		this.brokerId = brokerId;
	}

	/**
	 * 获取经纪人编号
	 * @return 经纪人编号
	 */
	public Integer getBrokerId() {
		return this.brokerId;
	}

	/**
	 * 设置经纪人名称
	 * @param brokerName 经纪人名称
	 */
	public void setBrokerName(String brokerName) {
		this.brokerName = brokerName;
	}

	/**
	 * 获取经纪人名称
	 * @return 经纪人名称
	 */
	public String getBrokerName() {
		return this.brokerName;
	}

	/**
	 * 设置经纪人手机号
	 * @param brokerPhone 经纪人手机号
	 */
	public void setBrokerPhone(String brokerPhone) {
		this.brokerPhone = brokerPhone;
	}

	/**
	 * 获取经纪人手机号
	 * @return 经纪人手机号
	 */
	public String getBrokerPhone() {
		return this.brokerPhone;
	}

	/**
	 * 设置经纪人公司名称
	 * @param brokerCompanyName 经纪人公司名称
	 */
	public void setBrokerCompanyName(String brokerCompanyName) {
		this.brokerCompanyName = brokerCompanyName;
	}

	/**
	 * 获取经纪人公司名称
	 * @return 经纪人公司名称
	 */
	public String getBrokerCompanyName() {
		return this.brokerCompanyName;
	}

	/**
	 * 设置总评论数
	 * @param totalCommetAmount 总评论数
	 */
	public void setTotalCommetAmount(Integer totalCommetAmount) {
		this.totalCommetAmount = totalCommetAmount;
	}

	/**
	 * 获取总评论数
	 * @return 总评论数
	 */
	public Integer getTotalCommetAmount() {
		return this.totalCommetAmount;
	}

	/**
	 * 设置5星星数量
	 * @param fiveStarAmount 5星星数量
	 */
	public void setFiveStarAmount(Integer fiveStarAmount) {
		this.fiveStarAmount = fiveStarAmount;
	}

	/**
	 * 获取5星星数量
	 * @return 5星星数量
	 */
	public Integer getFiveStarAmount() {
		return this.fiveStarAmount;
	}

	/**
	 * 设置4星星数量
	 * @param fourStarAmount 4星星数量
	 */
	public void setFourStarAmount(Integer fourStarAmount) {
		this.fourStarAmount = fourStarAmount;
	}

	/**
	 * 获取4星星数量
	 * @return 4星星数量
	 */
	public Integer getFourStarAmount() {
		return this.fourStarAmount;
	}

	/**
	 * 设置3星星数量
	 * @param threeStarAmount 3星星数量
	 */
	public void setThreeStarAmount(Integer threeStarAmount) {
		this.threeStarAmount = threeStarAmount;
	}

	/**
	 * 获取3星星数量
	 * @return 3星星数量
	 */
	public Integer getThreeStarAmount() {
		return this.threeStarAmount;
	}

	/**
	 * 设置2星星数量
	 * @param twoStarAmount 2星星数量
	 */
	public void setTwoStarAmount(Integer twoStarAmount) {
		this.twoStarAmount = twoStarAmount;
	}

	/**
	 * 获取2星星数量
	 * @return 2星星数量
	 */
	public Integer getTwoStarAmount() {
		return this.twoStarAmount;
	}

	/**
	 * 设置1星星数量
	 * @param oneStarAmount 1星星数量
	 */
	public void setOneStarAmount(Integer oneStarAmount) {
		this.oneStarAmount = oneStarAmount;
	}

	/**
	 * 获取1星星数量
	 * @return 1星星数量
	 */
	public Integer getOneStarAmount() {
		return this.oneStarAmount;
	}

	/**
	 * 设置最早评论时间
	 * @param earliestCommentTime 最早评论时间
	 */
	public void setEarliestCommentTime(java.util.Date earliestCommentTime) {
		this.earliestCommentTime = earliestCommentTime;
	}

	/**
	 * 设置最早评论时间字符串格式
	 * @param earliestCommentTime 最早评论时间
	 */
	public void setEarliestCommentTimeStr(String earliestCommentTime) {
		if (!com.house365.web.util.StringUtils.isBlank(earliestCommentTime)) {
			try {
				this.earliestCommentTime = java.text.DateFormat.getDateTimeInstance().parse(earliestCommentTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取最早评论时间
	 * @return 最早评论时间
	 */
	public java.util.Date getEarliestCommentTime() {
		return this.earliestCommentTime;
	}

	/**
	 * 设置标签编号-逗号分隔
	 * @param labels 标签编号-逗号分隔
	 */
	public void setLabels(String labels) {
		this.labels = labels;
	}

	/**
	 * 获取标签编号-逗号分隔
	 * @return 标签编号-逗号分隔
	 */
	public String getLabels() {
		return this.labels;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置是否删除
	 * @param isDeleted 是否删除
	 */
	public void setIsDeleted(Integer isDeleted) {
		this.isDeleted = isDeleted;
	}

	/**
	 * 获取是否删除
	 * @return 是否删除
	 */
	public Integer getIsDeleted() {
		return this.isDeleted;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("BrokerId",getBrokerId())
			.append("BrokerName",getBrokerName())
			.append("BrokerPhone",getBrokerPhone())
			.append("BrokerCompanyName",getBrokerCompanyName())
			.append("TotalCommetAmount",getTotalCommetAmount())
			.append("FiveStarAmount",getFiveStarAmount())
			.append("FourStarAmount",getFourStarAmount())
			.append("ThreeStarAmount",getThreeStarAmount())
			.append("TwoStarAmount",getTwoStarAmount())
			.append("OneStarAmount",getOneStarAmount())
			.append("EarliestCommentTime",getEarliestCommentTime())
			.append("Labels",getLabels())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.append("IsDeleted",getIsDeleted())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmBrokerEntity == false) return false;
		if(this == obj) return true;
		CmBrokerEntity other = (CmBrokerEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

