/**
 * Description: CmAssessScore数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-12-29 上午 11:12:25
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmAssessScore数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
public class CmAssessScoreEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 评估编号
     */

    @NotNull
    private Integer assessId;

    /**
     * 用户id
     */
    @Length(max = 10, message = "长度需要大于0且小于10")
    private String userId;

    /**
     * 设备标识ID
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String deviceId;

    /**
     * H:高了 L:低了 A:准
     */
    @NotBlank
    @CheckScope("H,L,A")
    @Length(max = 1, message = "长度需要大于0且小于1")
    private String score;

    /**
     * 创建时间
     */
    @NotNull
    private java.util.Date createTime;

    //columns END
    /*
	public CmAssessScore(){
	}

	public CmAssessScore(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 设置评估编号
     * @param assessId 评估编号
     */
    public void setAssessId(Integer assessId) {
        this.assessId = assessId;
    }

    /**
     * 获取评估编号
     * @return 评估编号
     */
    public Integer getAssessId() {
        return this.assessId;
    }

    /**
     * 设置用户id
     * @param userId 用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取用户id
     * @return 用户id
     */
    public String getUserId() {
        return this.userId;
    }

    /**
     * 设置H:高了 L:低了 A:准
     * @param score H:高了 L:低了 A:准
     */
    public void setScore(String score) {
        this.score = score;
    }

    /**
     * 获取H:高了 L:低了 A:准
     * @return H:高了 L:低了 A:准
     */
    public String getScore() {
        return this.score;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("AssessId", getAssessId())
                .append("UserId", getUserId())
                .append("deviceid", getDeviceId())
                .append("Score", getScore())
                .append("CreateTime", getCreateTime())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmAssessScoreEntity == false) return false;
        if (this == obj) return true;
        CmAssessScoreEntity other = (CmAssessScoreEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

