/**
 * Description: CmAssess数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-12-29 上午 11:12:24
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmAssess数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
public class CmAssessEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * city编号
     */
    @NotBlank
    @Length(max = 10, message = "长度需要大于0且小于10")
    private String city;

    /**
     * 小区ID
     */
    @NotBlank
    @Length(max = 15, message = "长度需要大于0且小于15")
    private String blockId;

    /**
     * 小区名
     */
//    @NotBlank
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String blockName;

    /**
     * 朝向
     */
//    @NotBlank
    @Length(max = 4, message = "长度需要大于0且小于4")
    private String forward;

    /**
     * 房间数
     */
//    @NotBlank
    @Length(max = 2, message = "长度需要大于0且小于2")
    private String room;

    /**
     * 厅数
     */
    @Length(max = 3, message = "长度需要大于0且小于3")
    private String  livingRoom;

    /**
     * 面积
     */
    @NotBlank
    @Length(max = 7, message = "长度需要大于0且小于7")
    private String buildArea;

    /**
     * 楼层
     */
//    @NotBlank
    @Length(max = 3, message = "长度需要大于0且小于3")
    private String floor;

    /**
     * 总楼层
     */
//    @NotBlank
    @Length(max = 3, message = "长度需要大于0且小于3")
    private String totalFloor;

    /**
     * 用户ID
     */
    @Length(max = 10, message = "长度需要大于0且小于10")
    private String userId;

    /**
     * 设备标识ID
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String deviceId;

    /**
     * 房屋评估总价(元)
     */
    @NotNull
    private java.math.BigDecimal totalPrice;

    /**
     * 房屋评估单价(元)
     */
    @NotNull
    private java.math.BigDecimal unitPrice;

    /**
     * 创建时间
     */
    @NotNull
    private java.util.Date createTime;

    private String assessDate;

    private String timestamp;

    //1展示0不展示
    @NotNull
    private String status;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getAssessDate() {
        return assessDate;
    }

    public void setAssessDate(String assessDate) {
        this.assessDate = assessDate;
    }

    public String getLivingRoom() {
        return livingRoom;
    }

    public void setLivingRoom(String livingRoom) {
        this.livingRoom = livingRoom;
    }

    //columns END
    /*
	public CmAssess(){
	}

	public CmAssess(
		Integer assessId
	){
		this.assessId = assessId;
	}

    */

    /**
     * 设置city编号
     * @param city city编号
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取city编号
     * @return city编号
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置小区ID
     * @param blockId 小区ID
     */
    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    /**
     * 获取小区ID
     * @return 小区ID
     */
    public String getBlockId() {
        return this.blockId;
    }

    /**
     * 设置小区名
     * @param blockName 小区名
     */
    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    /**
     * 获取小区名
     * @return 小区名
     */
    public String getBlockName() {
        return this.blockName;
    }

    /**
     * 设置朝向
     * @param forward 朝向
     */
    public void setForward(String forward) {
        this.forward = forward;
    }

    /**
     * 获取朝向
     * @return 朝向
     */
    public String getForward() {
        return this.forward;
    }

    /**
     * 设置房间数
     * @param room 房间数
     */
    public void setRoom(String room) {
        this.room = room;
    }

    /**
     * 获取房间数
     * @return 房间数
     */
    public String getRoom() {
        return this.room;
    }

    /**
     * 设置面积
     * @param buildArea 面积
     */
    public void setBuildArea(String buildArea) {
        this.buildArea = buildArea;
    }

    /**
     * 获取面积
     * @return 面积
     */
    public String getBuildArea() {
        return this.buildArea;
    }

    /**
     * 设置楼层
     * @param floor 楼层
     */
    public void setFloor(String floor) {
        this.floor = floor;
    }

    /**
     * 获取楼层
     * @return 楼层
     */
    public String getFloor() {
        return this.floor;
    }

    /**
     * 设置总楼层
     * @param totalFloor 总楼层
     */
    public void setTotalFloor(String totalFloor) {
        this.totalFloor = totalFloor;
    }

    /**
     * 获取总楼层
     * @return 总楼层
     */
    public String getTotalFloor() {
        return this.totalFloor;
    }

    /**
     * 设置用户ID
     * @param userId 用户ID
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取用户ID
     * @return 用户ID
     */
    public String getUserId() {
        return this.userId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 设置房屋评估总价(元)
     * @param totalPrice 房屋评估总价(元)
     */
    public void setTotalPrice(java.math.BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    /**
     * 获取房屋评估总价(元)
     * @return 房屋评估总价(元)
     */
    public java.math.BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    /**
     * 设置房屋评估单价(元)
     * @param unitPrice 房屋评估单价(元)
     */
    public void setUnitPrice(java.math.BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    /**
     * 获取房屋评估单价(元)
     * @return 房屋评估单价(元)
     */
    public java.math.BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("AssessId", getId())
                .append("City", getCity())
                .append("BlockId", getBlockId())
                .append("BlockName", getBlockName())
                .append("Forward", getForward())
                .append("Room", getRoom())
                .append("BuildArea", getBuildArea())
                .append("Floor", getFloor())
                .append("TotalFloor", getTotalFloor())
                .append("UserId", getUserId())
                .append("DeviceId", getDeviceId())
                .append("TotalPrice", getTotalPrice())
                .append("UnitPrice", getUnitPrice())
                .append("CreateTime", getCreateTime())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmAssessEntity == false) return false;
        if (this == obj) return true;
        CmAssessEntity other = (CmAssessEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

