/**
 * Description: CmAddGoods数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:04
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmAddGoods数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmAddGoodsEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 商品编号
	 */
	
	private Integer goodId;
	
	/**
	 * 商品名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String goodName;
	
	/**
	 * 商品数量
	 */
	
	private Integer amount;
	
	/**
	 * 操作人编号
	 */
	
	private Integer operatorId;
	
	/**
	 * 操作人姓名
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String operatorName;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
	 * 操作日期
	 */
	
	private java.util.Date createTime;
	
	//columns END
	/*
	public CmAddGoods(){
	}

	public CmAddGoods(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置商品编号
	 * @param goodId 商品编号
	 */
	public void setGoodId(Integer goodId) {
		this.goodId = goodId;
	}

	/**
	 * 获取商品编号
	 * @return 商品编号
	 */
	public Integer getGoodId() {
		return this.goodId;
	}

	/**
	 * 设置商品名称
	 * @param goodName 商品名称
	 */
	public void setGoodName(String goodName) {
		this.goodName = goodName;
	}

	/**
	 * 获取商品名称
	 * @return 商品名称
	 */
	public String getGoodName() {
		return this.goodName;
	}

	/**
	 * 设置商品数量
	 * @param amount 商品数量
	 */
	public void setAmount(Integer amount) {
		this.amount = amount;
	}

	/**
	 * 获取商品数量
	 * @return 商品数量
	 */
	public Integer getAmount() {
		return this.amount;
	}

	/**
	 * 设置操作人编号
	 * @param operatorId 操作人编号
	 */
	public void setOperatorId(Integer operatorId) {
		this.operatorId = operatorId;
	}

	/**
	 * 获取操作人编号
	 * @return 操作人编号
	 */
	public Integer getOperatorId() {
		return this.operatorId;
	}

	/**
	 * 设置操作人姓名
	 * @param operatorName 操作人姓名
	 */
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	/**
	 * 获取操作人姓名
	 * @return 操作人姓名
	 */
	public String getOperatorName() {
		return this.operatorName;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置操作日期
	 * @param createTime 操作日期
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置操作日期字符串格式
	 * @param createTime 操作日期
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取操作日期
	 * @return 操作日期
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("GoodId",getGoodId())
			.append("GoodName",getGoodName())
			.append("Amount",getAmount())
			.append("OperatorId",getOperatorId())
			.append("OperatorName",getOperatorName())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.append("CreateTime",getCreateTime())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmAddGoodsEntity == false) return false;
		if(this == obj) return true;
		CmAddGoodsEntity other = (CmAddGoodsEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

