package com.house365.beans.entity;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * 校验类，必须在指定范围内 如： "a,b,c,d" ,必须在a,b,c,d中
 */
@Target({ ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = CheckScopeValidator.class)
@Documented
public @interface CheckScope {

    String message() default "不在指定范围";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    String value();

}
