/**
 * Description: 客户状态变更纪录业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.CustomerStatusLogEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.service.system.Interfaces.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 客户状态变更纪录业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerStatusLogService<T extends CustomerStatusLogEntity> extends Service<T> {

    void addStatusLog(Integer customerId, Integer fromStatus, Integer toStatus, String remark, String updater) throws Exception;

    void addStatusLogWithProject(
            Integer customerId, Integer fromStatus, Integer toStatus, String remark, String updater, Date occurTime, Integer projectId,
            Integer isRepeat, Integer statisticFlag
    ) throws Exception;

    List<Map<String, Long>> getProjectTransform(Map<String, Object> map);

    List<Map<String, Object>> getProjectSource(ProjectSrouceParaPo map);

    /**
     * 获取带看次数
     *
     * @param managerId 置业顾问id
     * @return
     */
    int getSeeCount(Integer managerId);
}
