/**
 * Description: 回访录音记录业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-29 下午 16:40:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.ReceiveCallRecordEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IReceiveCallRecordDao;
import com.house365.ws.service.interfaces.IReceiveCallRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 回访录音记录业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-29
 * @see
 * @since 1.0
 */
@Service("reciveCallRecordService")
public class ReceiveCallRecordServiceImpl<T extends ReceiveCallRecordEntity> extends DefaultServiceImpl<T> implements IReceiveCallRecordService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IReceiveCallRecordDao<T> reciveCallRecordDao;

    @Override
    protected Dao<T> getDao() {
        return reciveCallRecordDao;
    }
}