/**
 * Description: DeptSourceStatistics业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:42:11
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.IDeptSourceStatisticsDao;
import com.house365.ws.service.interfaces.IDeptSourceStatisticsService;
import com.house365.beans.entity.DeptSourceStatisticsEntity;

/**
 * DeptSourceStatistics业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Service("deptSourceStatisticsService")
public class DeptSourceStatisticsServiceImpl<T extends DeptSourceStatisticsEntity> extends DefaultServiceImpl<T> implements IDeptSourceStatisticsService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IDeptSourceStatisticsDao<T> deptSourceStatisticsDao;

    @Override
    protected Dao<T> getDao() {
        return deptSourceStatisticsDao;
    }

    @Override
    public List<Map> statisticCustomer(QueryParams para) {
        return deptSourceStatisticsDao.statisticCustomer(para);
    }

    @Override
    public List<Map> statisticCustomerByWeek(QueryParams para) {
        return deptSourceStatisticsDao.statisticCustomerByWeek(para);
    }

    @Override
    public List<Map> statisticCustomerByMonth(QueryParams para) {
        return deptSourceStatisticsDao.statisticCustomerByMonth(para);
    }

    @Override
    public List<Map> transCustomer(QueryParams<T> para) {
        return deptSourceStatisticsDao.transCustomer(para);
    }

    @Override
    public List<Map> transCustomerByWeek(QueryParams<T> para) {
        return deptSourceStatisticsDao.transCustomerByWeek(para);
    }

    @Override
    public List<Map> transCustomerByMonth(QueryParams<T> para) {
        return deptSourceStatisticsDao.transCustomerByMonth(para);
    }

    @Override
    public void updateNames() {
        deptSourceStatisticsDao.updateProjectName();
        deptSourceStatisticsDao.updateSourceName();
        deptSourceStatisticsDao.updateCityName();
    }

    @Override
    public void deleteByDate(String startDateStr) {
        deptSourceStatisticsDao.deleteByDate(startDateStr);
    }

}
