package com.house365.ws.service.impl;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.DictionaryEntity;
import com.house365.ws.dao.mapper.CustomerMapper;
import com.house365.ws.dao.mapper.CustomerMergeMapper;
import com.house365.ws.service.interfaces.ICheckNoCallCustomer;
import com.house365.ws.service.interfaces.ICustomerService;
import com.house365.ws.util.OperateLogUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

@Service("checkNoApproximateCustomer")
public class CheckNoCallCustomer implements ICheckNoCallCustomer {

    @Autowired
    private ICustomerService<CustomerEntity> customerService;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private OperateLogUtils logUtils;
    @Autowired
    private CustomerMergeMapper customermergemapper;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void backToSea() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String time = sdf.format(date);
        //先取城市对应的参数值
        Map<String, Object> parammap = new HashMap<>(10);
        parammap.put("dicKey", "customer.remove.days.nocallrecord");
        List<DictionaryEntity> cityNoCalLss = customerService.getNoApproximateConfig(parammap);
        if (CollectionUtils.isNotEmpty(cityNoCalLss)) {
            for (DictionaryEntity entity : cityNoCalLss) {
                String city = entity.getCity();
                String days = entity.getDicValue();
                Map<String, Object> map = new HashMap<>(10);
                map.put("city", city);
                map.put("days", days);
                map.put("isRecycled", "1");
                map.put("date", time);
                map.put("updaterId", "cron");

                // 添加客户移入公海日志
                List<CustomerEntity> list = customerMapper.backToSeaCustomer(map);
                List<CustomerEntity> list2 = new ArrayList<>();
                List<Integer> ids = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (CustomerEntity c : list) {
                        //剔除越看记录
                        map.put("managerId", c.getManagerId());
                        map.put("phone", c.getPhone());
                        List<CustomerEntity> cps = customerMapper.getCpsByPhone(map);
                        if(cps ==null || cps.size()==0){
                            ids.add(c.getId());
                            list2.add(c);
                        }
                    }
                    if(ids.size()>0){
//                        map.put("ids", ids);
                        //超过N天无约看记录回公海
                        for (CustomerEntity c : list2) {
                            c.setLastManager(c.getManagerName());
                            c.setOceanDate(date);
                            c.setUpdateTime(date);
                            c.setIsRecycled(1);
                            c.setUpdater("cron");
                            c.setCityCode(city);
                            customerMapper.noApproximateBackToSea2(c);
                            //删除回公海的客户
                            customermergemapper.clearCustomerMerge2(c);
                            logUtils.saveCustomerLog(c, 6, 0, "backToSea定时接口");
                        }
                    }
                }
            }
        }
    }

}
