package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.BaseAttachment;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.po.UserPo;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.web.util.StringUtils;
import com.house365.ws.service.interfaces.IAttachmentService;
import com.house365.ws.service.interfaces.ICustomerStatusLogService;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>Title: 绑定客户与客户经理</p>
 * <p>Description: </p>
 * <p>Date: 16/9/15</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("getUserInfoById")
public class GetUserInfoByIdImpl implements IGetUserInfoById {

    private static final Logger LOGGER = LoggerFactory.getLogger(GetUserInfoByIdImpl.class);

    @Autowired
    private IUserService userService;
    @Autowired
    private ICustomerStatusLogService customerStatusLogService;
    @Autowired
    private IAttachmentService attachmentService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<UserPo> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            House365RestObject<UserPo> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        return JSONObject.fromObject(response).toString();
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<UserPo> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<UserPo> restObject = new House365RestObject<>();
        String userId = getMapValueByKey("userId", map, "");
        String city = getMapValueByKey("city", map, "");

        UserEntity userEntity = (UserEntity) userService.getById(Integer.valueOf(userId));
        //如果置业顾问被冻结，则不返回
        if (!userEntity.getEnabled()) {
            return restObject;
        }
        UserPo user = new UserPo();
        user.setId(userEntity.getId());
        user.setAccId(userEntity.getAccId());
        user.setRealName(userEntity.getRealName());

        //查询该城市是否展示IM窗口
        UserEntity imentity = userService.getByCity(city);
        if(imentity != null) {
            user.setImshow(imentity.getImshow());
        }

        List<BaseAttachment> headImg = attachmentService.queryByResourceIdAndResouceType(
                String.valueOf(userId), "hgs_user_headImg");
        List<BaseAttachment> fullImg = attachmentService.queryByResourceIdAndResouceType(
                String.valueOf(userId), "hgs_user_fullImg");

        if(CollectionUtils.isNotEmpty(headImg)){
            user.setHeadImgURL(headImg.get(0).getRemotePath());
        } else {
            user.setHeadImgURL("http://img33.house365.com/M00/1B/86/rBEBp1pu2JyAIp4jAAAGEjOUX2M365.jpg");
        }
        if(CollectionUtils.isNotEmpty(fullImg)){
            user.setFullImgURL(fullImg.get(0).getRemotePath());
        } else {
            user.setFullImgURL("http://img31.house365.com/M00/52/5E/rBEBYFpu2HGAb7o1AAAJ0juvDio725.jpg");
        }

        user.setGoodat(userEntity.getGoodat());
        user.setDescription(userEntity.getDescription());
        user.setScore(String.format("%.1f", userEntity.getScore()));
        user.setEvaluateCount(userEntity.getEvaluateCount());

        //获取带看次数
        int seeCount = customerStatusLogService.getSeeCount(userEntity.getId());
        seeCount += userEntity.getDefaultVisit();
        user.setSeeCount(seeCount);
        user.setDefaultVisit(userEntity.getDefaultVisit());

        //400短号分机号前加公司固话
        if (StringUtils.isNotBlank(userEntity.getHotlinephone())) {
            user.setHotlinephone("4008908365," + userEntity.getHotlinephone());
            user.setCornet("4008908365," + userEntity.getHotlinephone());
        }

        restObject.setEntity(user);

        return restObject;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
            Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
