/**
 * Description: 角色WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.RoleEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.RoleListRequest;
import com.house365.ws.beans.request.RoleRequest;
import com.house365.ws.beans.response.RoleListResponse;
import com.house365.ws.beans.response.RoleResponse;
import com.house365.ws.interfaces.server.IRole;
import com.house365.ws.service.interfaces.IRoleService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 角色WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("role")
public class RoleImpl implements IRole {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleImpl.class);

    /**
     * 角色服务对象
     */
    @Autowired
    IRoleService<RoleEntity> roleService;

    /**
     * 角色列表查询
     *
     * @param request 角色列表查询请求
     * @return 角色列表查询响应
     */
    @Override
    public RoleListResponse getRoleList(RoleListRequest request) {
        RoleListResponse response = new RoleListResponse();
        try {
            QueryParams<RoleEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<RoleEntity> roles = roleService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(roles);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存角色
     *
     * @param request 角色请求
     * @return 保存角色响应
     */
    @Override
    public RoleResponse addRole(RoleRequest request) {
        RoleResponse response = new RoleResponse();
        try {
            RoleEntity entity = request.getEntity();
            roleService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除角色通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除角色响应
     */
    @Override
    public RoleResponse deleteRoleById(Integer id) {
        RoleResponse response = new RoleResponse();
        try {
            roleService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改角色
     *
     * @param request 修改角色请求
     * @return 修改角色响应
     */
    @Override
    public RoleResponse updateRole(RoleRequest request) {
        RoleResponse response = new RoleResponse();
        try {
            roleService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取角色
     *
     * @param id 唯一标识
     * @return 通过ID获取角色响应
     */
    @Override
    public RoleResponse getRoleById(Integer id) {
        RoleResponse response = new RoleResponse();
        try {
            RoleEntity entity = roleService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
