/**
 * Description: ProjectSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.po.ProjectSrouceRePo;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.ProjectSourceStatisticsListRequest;
import com.house365.ws.beans.request.ProjectSourceStatisticsRequest;
import com.house365.ws.beans.response.ProjectSourceStatisticsListResponse;
import com.house365.ws.beans.response.ProjectSourceStatisticsResponse;
import com.house365.ws.interfaces.server.IProjectSourceStatistics;
import com.house365.ws.service.interfaces.IProjectSourceStatisticsService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * ProjectSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
@Service("projectSourceStatistics")
public class ProjectSourceStatisticsImpl implements IProjectSourceStatistics {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectSourceStatisticsImpl.class);

    /**
     * ProjectSourceStatistics服务对象
     */
    @Autowired
    IProjectSourceStatisticsService<ProjectSourceStatisticsEntity> projectSourceStatisticsService;

    @Override
    public List<ProjectSrouceRePo> getProjectSourceStatistics(ProjectSrouceParaPo para) {
        List<ProjectSrouceRePo> resultLi = null;
        para.setIsRepeat(0);
        if (para.getDateViewType() == 1) {
            resultLi = projectSourceStatisticsService.queryByDay(para);
        } else if (para.getDateViewType() == 2) {
            resultLi = projectSourceStatisticsService.queryByWeek(para);
        } else {
            resultLi = projectSourceStatisticsService.queryByMonth(para);
        }
        return resultLi;
    }


    /**
     * ProjectSourceStatistics列表查询
     *
     * @param request ProjectSourceStatistics列表查询请求
     * @return ProjectSourceStatistics列表查询响应
     */
    @Override
    public ProjectSourceStatisticsListResponse getProjectSourceStatisticsList(
            ProjectSourceStatisticsListRequest request
    ) {
        ProjectSourceStatisticsListResponse response = new ProjectSourceStatisticsListResponse();
        try {
            QueryParams<ProjectSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ProjectSourceStatisticsEntity> projectSourceStatisticss = projectSourceStatisticsService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(projectSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存ProjectSourceStatistics
     *
     * @param request ProjectSourceStatistics请求
     * @return 保存ProjectSourceStatistics响应
     */
    @Override
    public ProjectSourceStatisticsResponse addProjectSourceStatistics(
            ProjectSourceStatisticsRequest request
    ) {
        ProjectSourceStatisticsResponse response = new ProjectSourceStatisticsResponse();
        try {
            ProjectSourceStatisticsEntity entity = request.getEntity();
            projectSourceStatisticsService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除ProjectSourceStatistics通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除ProjectSourceStatistics响应
     */
    @Override
    public ProjectSourceStatisticsResponse deleteProjectSourceStatisticsById(Integer id) {
        ProjectSourceStatisticsResponse response = new ProjectSourceStatisticsResponse();
        try {
            projectSourceStatisticsService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改ProjectSourceStatistics
     *
     * @param request 修改ProjectSourceStatistics请求
     * @return 修改ProjectSourceStatistics响应
     */
    @Override
    public ProjectSourceStatisticsResponse updateProjectSourceStatistics(
            ProjectSourceStatisticsRequest request
    ) {
        ProjectSourceStatisticsResponse response = new ProjectSourceStatisticsResponse();
        try {
            projectSourceStatisticsService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取ProjectSourceStatistics
     *
     * @param id 唯一标识
     * @return 通过ID获取ProjectSourceStatistics响应
     */
    @Override
    public ProjectSourceStatisticsResponse getProjectSourceStatisticsById(Integer id) {
        ProjectSourceStatisticsResponse response = new ProjectSourceStatisticsResponse();
        try {
            ProjectSourceStatisticsEntity entity = projectSourceStatisticsService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public ProjectSourceStatisticsListResponse statisticCustomer(
            ProjectSourceStatisticsListRequest request
    ) {
        ProjectSourceStatisticsListResponse response = new ProjectSourceStatisticsListResponse();
        try {
            QueryParams<ProjectSourceStatisticsEntity> queryParams = new QueryParams<ProjectSourceStatisticsEntity>(
                    request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ProjectSourceStatisticsEntity> projectSourceStatisticss = projectSourceStatisticsService.statisticCustomer(
                    queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(projectSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
