package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ExternalCustomerLogEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.dao.mapper.ExternalCustomerLogMapper;
import com.house365.ws.interfaces.server.IExternalCusLogInterface;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2020/7/2.
 */
@Service("externalCusLog")
public class ExternalCusLogImpl implements IExternalCusLogInterface {

    @Autowired
    private ExternalCustomerLogMapper logMapper;

    @Override
    public void save(ExternalCustomerLogEntity entity) {
        logMapper.save(entity);
    }

    @Override
    public List<ExternalCustomerLogEntity> queryByConditions(Map<String, Object> map) {
        List<ExternalCustomerLogEntity> list = logMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
