package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.ws.dao.mapper.CustomerMapper;
import com.house365.ws.dao.mapper.DepartMapper;
import com.house365.ws.dao.mapper.UserMapper;
import com.house365.ws.interfaces.server.IExportExcelInterface;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/2/25.
 */
@Service("exportExcel")
@Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
public class ExportExcelImpl implements IExportExcelInterface {

    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private DepartMapper departMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    public List<Map<String, Object>> queryCount() {
        List<Map<String, Object>> list = customerMapper.queryCount();
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> queryByManagerId(Map<String, Object> map) {
        List<Map<String, Object>> list = customerMapper.queryByManagerId(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public UserEntity getById(int id) {
        return userMapper.getById(id);
    }

    @Override
    public List<Map<String, Object>> queryCustomerLog(Map<String, Object> map) {
        List<Map<String, Object>> list = customerMapper.queryCustomerLog(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> queryCustomerByStatus(Map<String, Object> map) {
        List<Map<String, Object>> list = customerMapper.queryCustomerByStatus(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public int queryCustomerLogCount(Map<String, Object> map) {
        return customerMapper.queryCustomerLogCount(map);
    }

    @Override
    public int queryCustomerByStatusCount(Map<String, Object> map) {
        return customerMapper.queryCustomerByStatusCount(map);
    }

    @Override
    public List<CustomerEntity> queryAllByCity() {
        List<CustomerEntity> list = customerMapper.queryAllByCity();
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> queryByCondition(Map<String, Object> map) {
        List<String> list = customerMapper.queryByCondition(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> queryCustomerLogBySource(Map<String, Object> map) {
        List<Map<String, Object>> resultList = customerMapper.queryCustomerLogBySource(map);
        if (CollectionUtils.isNotEmpty(resultList)) {
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> queryBySource(Map<String, Object> map) {
        List<Map<String, Object>> list = customerMapper.queryBySource(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> queryByStatusAndSource(Map<String, Object> map) {
        List<Map<String, Object>> list = customerMapper.queryByStatusAndSource(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public DepartmentEntity queryById(int id) {
        return departMapper.queryById(id);
    }

    @Override
    public List<Map<String, Object>> querySource() {
        List<Map<String, Object>> list = customerMapper.querySource();
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }
}
