/**
 * Description: DeptSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:42:11
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.DeptSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.DeptSourceStatisticsListRequest;
import com.house365.ws.beans.request.DeptSourceStatisticsRequest;
import com.house365.ws.beans.response.DeptSourceStatisticsListResponse;
import com.house365.ws.beans.response.DeptSourceStatisticsResponse;
import com.house365.ws.beans.response.SourceStatisticsListResponse;
import com.house365.ws.interfaces.server.IDeptSourceStatistics;
import com.house365.ws.service.interfaces.IDeptSourceStatisticsService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * DeptSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Service("deptSourceStatistics")
public class DeptSourceStatisticsImpl implements IDeptSourceStatistics {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(DeptSourceStatisticsImpl.class);

    /**
     * DeptSourceStatistics服务对象
     */
    @Autowired
    IDeptSourceStatisticsService<DeptSourceStatisticsEntity> deptSourceStatisticsService;

    /**
     * DeptSourceStatistics列表查询
     *
     * @param request DeptSourceStatistics列表查询请求
     * @return DeptSourceStatistics列表查询响应
     */
    @Override
    public DeptSourceStatisticsListResponse getDeptSourceStatisticsList(DeptSourceStatisticsListRequest request) {
        DeptSourceStatisticsListResponse response = new DeptSourceStatisticsListResponse();
        try {
            QueryParams<DeptSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<DeptSourceStatisticsEntity> deptSourceStatisticss = deptSourceStatisticsService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(deptSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存DeptSourceStatistics
     *
     * @param request DeptSourceStatistics请求
     * @return 保存DeptSourceStatistics响应
     */
    @Override
    public DeptSourceStatisticsResponse addDeptSourceStatistics(DeptSourceStatisticsRequest request) {
        DeptSourceStatisticsResponse response = new DeptSourceStatisticsResponse();
        try {
            DeptSourceStatisticsEntity entity = request.getEntity();
            deptSourceStatisticsService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除DeptSourceStatistics通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除DeptSourceStatistics响应
     */
    @Override
    public DeptSourceStatisticsResponse deleteDeptSourceStatisticsById(Integer id) {
        DeptSourceStatisticsResponse response = new DeptSourceStatisticsResponse();
        try {
            deptSourceStatisticsService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改DeptSourceStatistics
     *
     * @param request 修改DeptSourceStatistics请求
     * @return 修改DeptSourceStatistics响应
     */
    @Override
    public DeptSourceStatisticsResponse updateDeptSourceStatistics(DeptSourceStatisticsRequest request) {
        DeptSourceStatisticsResponse response = new DeptSourceStatisticsResponse();
        try {
            deptSourceStatisticsService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取DeptSourceStatistics
     *
     * @param id 唯一标识
     * @return 通过ID获取DeptSourceStatistics响应
     */
    @Override
    public DeptSourceStatisticsResponse getDeptSourceStatisticsById(Integer id) {
        DeptSourceStatisticsResponse response = new DeptSourceStatisticsResponse();
        try {
            DeptSourceStatisticsEntity entity = deptSourceStatisticsService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 获取统计信息
     *
     * @param request
     * @param dateViewType 1日视图2周视图3月视图
     * @return
     */
    @Override
    public SourceStatisticsListResponse statisticCustomer(
            DeptSourceStatisticsListRequest request, String dateViewType
    ) {
        SourceStatisticsListResponse response = new SourceStatisticsListResponse();
        try {
            QueryParams<DeptSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());

            List<Map> projectSourceStatisticss = new ArrayList<>();
            if ("1".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = deptSourceStatisticsService.statisticCustomer(queryParams);
            } else if ("2".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = deptSourceStatisticsService.statisticCustomerByWeek(queryParams);
            } else if ("3".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = deptSourceStatisticsService.statisticCustomerByMonth(queryParams);
            }

            for (Map map : projectSourceStatisticss) {
                BigDecimal curData = map.get("customerNum") == null ? BigDecimal.ZERO : new BigDecimal(
                        String.valueOf(map.get("customerNum")));
                BigDecimal preData = map.get("prenum") == null ? BigDecimal.ZERO : new BigDecimal(
                        String.valueOf(map.get("prenum")));
                if (preData.compareTo(BigDecimal.ZERO) <= 0) {
                    map.put("huanbi", "-");
                } else {
                    BigDecimal huanbi = curData.subtract(preData).setScale(4).divide(preData, BigDecimal.ROUND_HALF_UP);
                    if (huanbi.compareTo(BigDecimal.ZERO) == 0) {
                        map.put("huanbi", "-");
                    } else {
                        map.put("huanbi", huanbi.multiply(new BigDecimal(100)).setScale(2) + "%");
                    }
                }
            }

            response.setPaging(queryParams.getPaging());
            response.setObjectList(projectSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 客户转化分析
     *
     * @param request
     * @param dateViewType
     * @return
     */
    @Override
    public SourceStatisticsListResponse customerTrans(
            DeptSourceStatisticsListRequest request, String dateViewType
    ) {
        SourceStatisticsListResponse response = new SourceStatisticsListResponse();
        try {
            QueryParams<DeptSourceStatisticsEntity> queryParams = new QueryParams<>(
                    request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());

            List<Map> projectSourceStatisticss = new ArrayList<>();
            if ("1".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = deptSourceStatisticsService.transCustomer(queryParams);
            } else if ("2".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = deptSourceStatisticsService.transCustomerByWeek(queryParams);
            } else if ("3".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = deptSourceStatisticsService.transCustomerByMonth(queryParams);
            }

            response.setPaging(queryParams.getPaging());
            response.setObjectList(projectSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
