package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerCallbackTemplateEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CustomerCallbackTemplateListRequest;
import com.house365.ws.beans.response.CustomerCallbackTemplateListResponse;
import com.house365.ws.interfaces.server.ICustomerCallbackTemplate;
import com.house365.ws.service.interfaces.ICustomerCallbackTemplateService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("customerCallbackTemplate")
public class CustomerCallbackTemplateImpl implements ICustomerCallbackTemplate {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerCallbackTemplateImpl.class);

    @Autowired
    private ICustomerCallbackTemplateService<CustomerCallbackTemplateEntity> customerCallbackTemplateService;

    /**
     * CustomerCallbackTemplate列表查询
     *
     * @param request CustomerCallbackTemplate列表查询请求
     * @return CustomerCallbackTemplate列表查询响应
     */
    @Override
    public CustomerCallbackTemplateListResponse getCustomerCallbackTemplateList(CustomerCallbackTemplateListRequest request) {

        CustomerCallbackTemplateListResponse response = new CustomerCallbackTemplateListResponse();
        try {
            QueryParams<CustomerCallbackTemplateEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CustomerCallbackTemplateEntity> customerCallbackTemplates = customerCallbackTemplateService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(customerCallbackTemplates);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 执行服务
     *
     * @param parameter 服务输入，不包含服务配置和控制信息
     * @return 执行结果，目前为对json的封装，可以为null
     * @throws ServiceRunException 如果运行的服务发生异常则抛出服务运行时异常
     */
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    /**
     * 判断服务是否具有控制逻辑
     *
     * @return 是否判断
     */
    @Override
    public boolean isControlService() {
        return false;
    }

    /**
     * 判断服务是否需要记录日志
     *
     * @return 是否判断
     */
    @Override
    public boolean isLogService() {
        return false;
    }

    /**
     * 判断服务是否需要监控
     *
     * @return 是否判断
     */
    @Override
    public boolean isMonitorService() {
        return false;
    }

    /**
     * 事务回滚
     *
     * @return 事务回滚预留结果，暂无用途
     */
    @Override
    public Object rollback() {
        return null;
    }

    /**
     * 事务提交
     */
    @Override
    public void commit() {

    }
}
