/**
 * Description: ProjectSaler数据访问接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-23 下午 17:14:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-23   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;
import java.util.Map;

/**
 * ProjectSaler数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-23
 * @see
 * @since 1.0
 */
public interface IProjectSalerDao<T extends ProjectSalerEntity> extends Dao<T> {

    List<UserEntity> queryUserByPrjId(Map<String, Object> params);

    void deleteByProjectId(Map<String, Object> params);

    void deleteByUserId(String userId);

    List<ProjectSalerEntity> queryAllList();

    void updateStatus(int id);
}
