/**
 * Description: 客户信息数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:13
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.CrmVisitAndSignCustomer;
import com.house365.dao.system.interfaces.Dao;
import com.house365.ws.beans.request.CustomerListRequest;

import java.util.List;
import java.util.Map;

/**
 * 客户信息数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerDao<T extends CustomerEntity> extends Dao<T> {
    List<Map<String, Object>> getNewCustomerIds(String managerId);

    List<Map<String, Object>> getTodayUpdateIds(String managerId);

    List<Map<String, Object>> getNocallSevenDayIds(String managerId);

    List<Map<String, Object>> getNocallThreeDayIds(String managerId);

    Map<String, Object> getSummary(String managerId);
    Map<String, Object> getNewSummary(Map<String, String> summaryParams);

    Map<String, Object> getSummarySimple(String managerId);

    Map<String, Object> getSummaryForCRM(String phone);

    Map<String, Object> getSummary7ForCRM(String phone);

    Map<String, Object> getSeaSummary(String cityCode);

    Map<String, Object> getSeaSummary2(String cityCode);

    Map<String, Object> getSeaSummary3(String cityCode);

    Map<String, Object> getWechatMyCucstomerSummary(String managerId);

    List<Map<String, Object>> getWechatMyCucstomerUserView(String managerId, String pageNo, String pageSize);

    List<Map<String, Object>> statisticByUser(Map<String, String> parameter);

    List<Map<String, Object>> statisticByStatus(Map<String, String> parameter);

    List<Map<String, Object>> statisticByDept(Map<String, String> parameter);

    List<Map<String, Object>> statisticByProject(Map<String, String> parameter);

    List<Map<String, Object>> statisticNoRecordByUser(Map<String, String> parameter);

    List<Map<String, Object>> statisticNoRecordByDept(Map<String, String> parameter);

    List<Map<String, Object>> statisticNoRecordByStatus(Map<String, String> parameter);

    void updateName(String oldName, String name);

    void delDynamic(Integer dynamicId);

    public void updateManager(Integer managerId, String managerName);

    List<Map<String, Object>> getNoStatusUpdateIds(String managerId);

    List<Map<String, Object>> getNoVisitIdsByDays(Map<String, Object> parameter);

    List<Map<String, Object>> getNoPledgedIdsByDays(Map<String, Object> parameter);

    //今日新增客户
    List<Integer> getNewAddCustomerIds(String managerId);

    //7日新增客户
    List<Integer> getCallInThreeDayIds(String managerId);

    //3天内回访的客户
    List<Integer> getStarCustomerIds(String managerId);

    //星标客户
    List<Integer> getSevenDayNewCustomerIds(String managerId);

    //客户最后回访记录
    List<Map<String, Object>> getLastestCallback(String customerIds);

    List<CustomerEntity> getCustomerManagementList(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getPlatformCustomerList(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getCustomerManagementList4Label(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getCustomerListFromOld(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getTotalCallOptimizeList(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getWechatCustomers(QueryParams<CustomerEntity> queryParams);

    void removeFromOcean();

    Integer getTotalCall(QueryParams<T> queryParams);

    Integer getTotalCallOptimize(QueryParams<T> queryParams);

    Integer getTotalAbandon(QueryParams<T> queryParams);

    List<Map<String,Object>> getNoCallByHours(Map<String, Object> parameter);

    List<Map<String, Object>> getMarketInfo(QueryParams<T> queryParams);

    List<CrmVisitAndSignCustomer> crmVisitAndSignCustomer(Map<String, Object> queryParams);

    void updateOldCustomers(CustomerEntity customer);
}
