/**
 * Description: 权限数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.WeChatPermissionEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IWeChatPermissionDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 权限数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Repository("weChatPermissionDao")
public class WeChatPermissionDaoImpl extends DefaultDaoImpl<WeChatPermissionEntity>
        implements IWeChatPermissionDao<WeChatPermissionEntity> {

    @Override
    public List<WeChatPermissionEntity> getPermissionsByUserId(Integer userId) {
        return this.getReadTemplate().queryForList(getStatement(), userId);
    }

    @Override
    public List<WeChatPermissionEntity> queryAllByOrder() {
        return this.getReadTemplate().queryForList(getStatement());
    }

    @Override
    public List<WeChatPermissionEntity> getPermissionsByParentId(Integer parentId) {
        return this.getReadTemplate().queryForList(getStatement(), parentId);
    }
}
