/**
 * Description: 抢客数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 上午 09:44:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.RushCustomerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IRushCustomerDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 抢客数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Repository("rushCustomerDao")
public class RushCustomerDaoImpl extends DefaultDaoImpl<RushCustomerEntity> implements IRushCustomerDao<RushCustomerEntity> {

    @Override
    public List<RushCustomerEntity> queryAllShow(QueryParams<?> queryParams) {
        return this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public int queryAllShowCount(QueryParams<?> queryParams) {
        return uniqueIntResult(getStatement("queryAllShow_count"), queryParams);
    }
}
