/**
 * Description: BaseTree数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-08 下午 15:16:07
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-08   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.BaseTreeEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IBaseTreeDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * BaseTree数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-08
 * @see
 * @since 1.0
 */
@Repository("baseTreeDao")
public class BaseTreeDaoImpl extends DefaultDaoImpl<BaseTreeEntity> implements IBaseTreeDao<BaseTreeEntity> {

    @Override
    public List<BaseTreeEntity> findChildrenListByPath(
            List<BaseTreeEntity> parents
    ) {
        List<String> paraList = new LinkedList<>();
        for (BaseTreeEntity baseTreeEntity : parents) {
            paraList.add(baseTreeEntity.getUrlPath());
        }
        return (List<BaseTreeEntity>) this.getReadTemplate().queryForList(getStatement(), paraList);
    }

    @Override
    public void clean(String sourceType) {
        Map<String, Object> map = new HashMap<>();
        map.put("sourceType", sourceType);
        getReadTemplate().delete(getStatement(), map);
    }


}
