/**
 * Description: 营销日报WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 下午 13:27:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.po.ReportDailyPo;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.ReportMarketingListRequest;
import com.house365.ws.beans.request.ReportMarketingRequest;
import com.house365.ws.beans.response.ReportMarketingListResponse;
import com.house365.ws.beans.response.ReportMarketingResponse;
import com.house365.ws.system.House365SearchResponse;

import java.util.List;


/**
 * 营销日报WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface IReportMarketing extends IService {

    /**
     * 营销日报列表查询
     *
     * @param request 营销日报列表查询请求
     * @return 营销日报列表查询响应
     */
    ReportMarketingListResponse getReportMarketingList(
            ReportMarketingListRequest request);

    /**
     * 保存营销日报
     *
     * @param request 营销日报请求
     * @return 保存营销日报响应
     */
    ReportMarketingResponse addReportMarketing(ReportMarketingRequest request);

    /**
     * 删除营销日报通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除营销日报响应
     */
    ReportMarketingResponse deleteReportMarketingById(Integer id);

    /**
     * 修改营销日报
     *
     * @param request 修改营销日报请求
     * @return 修改营销日报响应
     */
    ReportMarketingResponse updateReportMarketing(
            ReportMarketingRequest request);

    /**
     * 通过ID获取营销日报
     *
     * @param id 唯一标识
     * @return 通过ID获取营销日报响应
     */
    ReportMarketingResponse getReportMarketingById(Integer id);

    /**
     * 获取当月月报日历
     *
     * @param startTime 月报起始时间
     * @param endTime   月报结束时间
     * @param userIds
     *@param city  @return 已填写日报日期
     */
    List<ReportDailyPo> getDailies(String startTime, String endTime, List<Integer> userIds, String city);

    House365SearchResponse statistic(ReportMarketingListRequest reportRequest);
}
