/**
 * Description: DeptSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:42:11
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.DeptSourceStatisticsListRequest;
import com.house365.ws.beans.request.DeptSourceStatisticsRequest;
import com.house365.ws.beans.response.DeptSourceStatisticsListResponse;
import com.house365.ws.beans.response.DeptSourceStatisticsResponse;
import com.house365.ws.beans.response.SourceStatisticsListResponse;


/**
 * DeptSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
public interface IDeptSourceStatistics extends IService {

    /**
     * DeptSourceStatistics列表查询
     *
     * @param request
     *            DeptSourceStatistics列表查询请求
     * @return DeptSourceStatistics列表查询响应
     */
    DeptSourceStatisticsListResponse getDeptSourceStatisticsList(
        DeptSourceStatisticsListRequest request
    );

    /**
     * 保存DeptSourceStatistics
     *
     * @param request
     *            DeptSourceStatistics请求
     * @return 保存DeptSourceStatistics响应
     */
    DeptSourceStatisticsResponse addDeptSourceStatistics(DeptSourceStatisticsRequest request);

    /**
     * 删除DeptSourceStatistics通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除DeptSourceStatistics响应
     */
    DeptSourceStatisticsResponse deleteDeptSourceStatisticsById(Integer id);

    /**
     * 修改DeptSourceStatistics
     *
     * @param request
     *            修改DeptSourceStatistics请求
     * @return 修改DeptSourceStatistics响应
     */
    DeptSourceStatisticsResponse updateDeptSourceStatistics(
        DeptSourceStatisticsRequest request
    );

    /**
     * 通过ID获取DeptSourceStatistics
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取DeptSourceStatistics响应
     */
    DeptSourceStatisticsResponse getDeptSourceStatisticsById(Integer id);

    SourceStatisticsListResponse statisticCustomer(
        DeptSourceStatisticsListRequest request, String dateViewType
    );

    SourceStatisticsListResponse customerTrans(
        DeptSourceStatisticsListRequest request, String dateViewType
    );
}
