$.zTree = {
    index: 1,
    treeTemplate: '<ul id="treeSelect{id}" class="ztree"></ul>',

    selectTreeTemplate: '<div id="treeContent{id}" class="treeContent" style="display:none; position: absolute;">{tree}</div>',

    autocompleteTemplate: '<div class="control-group tree-search" style="margin-top:5px;">' +
    /*'<label for="searchName{id}">名称</label>' +*/
    '<div class="controls">' +
    '<input type="text" id="searchName{id}" class="input-medium" placeholder="模糊匹配 回车键查询"/>' +
    '</div>' +
    '</div>',

    /**
     * 初始化可移动树
     */
    initMovableTree: function (config) {
        config.addUrl = config.addUrl || (config.urlPrefix + "/ajax/{id}/appendChild");
        config.asyncLoadAll = config.asyncLoadAll || false;
        config.loadUrl = config.loadUrl || (config.urlPrefix + "/ajax/load" +
            "?async=" + config.async +
            "&asyncLoadAll=" + config.asyncLoadAll +
            (config.excludeId ? "&excludeId=" + config.excludeId : "") +
            (config.onlyDisplayShow == '1' ? "&show=1" : ""));

        if (config.editable != false) {
            config.editable = true;
        }

        if (!config.permission) {
            config.permission = {};
        }
        config.permission = $.extend({
            create: false,
            update: false,
            remove: false,
            move: false
        }, config.permission);


        var setting = {
            noSwitchIcon: true,
            maxLevel: -1,
            async: {
                enable: config.async,
                url: config.loadUrl,
                autoParam: ["id"],
                dataFilter: $.zTree.filter,
                otherParam: config.otherParam
            },
            check: config.check,
            edit: {
                enable: true,
                editNameSelectAll: true,
                showRemoveBtn: config.editable ? function (treeId, treeNode) {
                    return treeNode.id != '0';
                } : null,
                showRenameBtn: false,
                drag: {
                    isMove: false,
                    isCopy: false,
                    prev: drop,
                    inner: drop,
                    next: drop
                }
            },
            data: {
                simpleData: {
                    enable: true
                }
            }
        };

        if (!config.editable) {
            setting.edit = {};
            setting.view.addHoverDom = null;
            setting.view.removeHoverDom = null;
        }

        if (config, setting) {
            setting = $.extend(true, config.setting, setting);
            config.setting = setting;
        }

        function drop(treeId, nodes, targetNode) {
            if (!targetNode || !targetNode.getParentNode()) {
                return false;
            }
            for (var i = 0, l = nodes.length; i < l; i++) {
                if (nodes[i].root === true) {
                    return false;
                }
            }
            return true;
        }



        var autocomplateEnable = config.autocomplete && config.autocomplete.enable;

        var id = this.index++;
        var treeStr = (autocomplateEnable ? this.autocompleteTemplate : '') + this.treeTemplate;
        var container = null;
        if (config.containerId) {
            container = $("#" + config.containerId);
        } else {
            container = $("body");
        }

        container.append(treeStr.replace(/{id}/g, id));
        var treeSelect = "treeSelect" + id;
        var zTree = $.fn.zTree.init($("#" + treeSelect), setting, config.zNodes);

        if (autocomplateEnable) {
            if (!config.autocomplete.minLength) config.autocomplete.minLength = 0;
            config.autocomplete.enterSearch = true;
            config.autocomplete.input = $("#searchName" + id);
            config.autocomplete.async = config.autocomplete.async || config.async;
            config.autocomplete.select = config.autocomplete.select || function (event, ui) { //按照名字搜索
                var searchName = ui.item.value;
                var url = encodeURI(encodeURI(config.loadUrl + "&searchName=" + searchName));
                zTree.destroy();
                $.getJSON(url, function (zNodes) {
                    if (zNodes.length > 0) { //如果没找到节点就不必展示
                        zTree = $.fn.zTree.init($("#" + treeSelect), setting, zNodes);
                    }
                });
            };

            config.autocomplete.source = config.autocomplete.source
                || config.urlPrefix + "/ajax/autocomplete?1=1" +
                (config.excludeId ? "&excludeId=" + config.excludeId : "") +
                (config.onlyDisplayShow == '1' ? "&show=1" : "");

            config.treeId = treeSelect;
            $.app.initAutocomplete(config.autocomplete);
        }

        return treeSelect;

    }

}
