<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>用户授权</title>
</head>
<body>
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li>
                <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                <a href="${ctx}/user/${userId}">用户</a>
            </li>
            <li class="active">
                <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                <span class="inline">授权</span>
            </li>
        </ul>
    </div>
    <div class="span11">
        <div class="buttons pull-right">
            <a href="#" class="btn blue pull-right" title="确定授权" onclick="authorizeById('')">确定授权</a>
        </div>
        <input type="hidden" name="userId" id="userId" value="${userId}">
    </div>
</div>

<div class="page-container">
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>

            <!-- <th width="100">id</th> -->
            <th width="100">编码</th>
            <th width="100">名称</th>
            <th width="40"><input id="memberCheckAll" type="checkbox" onclick="checkAll(this)" hidden="hidden"/>是否授权
            </th>
            <!-- <th width="100">父权限ID</th> -->
            <!-- <th width="100">排序</th> -->
            <!-- <th width="100">对应资源</th> -->
            <!-- <th width="100">创建人</th>
            <th width="100">创建时间</th> -->
        </tr>
        </thead>
        <c:forEach items="${roles}" var="role">
            <tr>
                <td nowrap="nowrap">
                    <c:if test="${null ne role.code && '' ne role.code}">
                        <c:out value="${role.code}"/>
                    </c:if>
                    <c:if test="${null eq role.code || '' eq role.code}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne role.name && '' ne role.name}">
                        <c:out value="${role.name}"/>
                    </c:if>
                    <c:if test="${null eq role.name || '' eq role.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <input type="checkbox" name="memberCheck" value="${role.id}" onclick="checkMember(this)"
                           <c:if test="${role.authorized}">checked="checked"</c:if>  />
                </td>
            </tr>
        </c:forEach>
    </table>
</div>
<script type="text/javascript">

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var authorizeById = function (selectedId) {
        console.log(selectedId);
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            selectedId = -1;
        }
        console.log(selectedId);
        House365Util.createModal("用户授权", "确定授权？", function () {
            $.ajax({
                url: '${ctx}/userrole/authorize/' + $("#userId").val() + "/" + selectedId,
                type: "GET",
                success: function () {
                    window.location = "${ctx}/user/" + $("#userId").val();
                }
            });
        });

    };

</script>
</body>
</html>
