<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>

    <link rel="stylesheet" type="text/css" href="${static_common}/customize/css/fullcalendar.css">
    <link rel="stylesheet" type="text/css" href="${static_common}/customize/css/calendar.css">
    <style>
        .fc-future {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
<div id="calendar"></div>

<script type="text/javascript" src="${static_common}/script/jquery/jquery-1.10.2.js"></script>
<script type="text/javascript" src="${static_common}/customize/js/fullcalendar.min.js"></script>
<script type="text/javascript">
    $(function () {
        var datas = [];
        var prevDateArr = [], nextDateArr = [], curDateArr = [];
        var calendar = $('#calendar').fullCalendar({
            buttonText: {
                prev: '<i class="icon-chevron-left"></i>',
                next: '<i class="icon-chevron-right"></i>'
            },
            titleFormat: {
                month: 'yyyy年 MMMM'
            },
            monthNames: ['1月', '2月', '3月', '4月', '5月', '6月', '7月',
                '8月', '9月', '10月', '11月', '12月'
            ],
            dayNamesShort: ['周日', '周一', '周二', '周三',
                '周四', '周五', '周六'
            ],
            header: {
                left: 'title,prev,next',
                center: '',
                right: ''
            },
            firstDay: 1,
            aspectRatio: 1.2,
            dayRender: function (date, cell) {
                var day = $.fullCalendar.formatDate(date, "yyyy-MM-dd"),
                    month = getMonth(day),
                    year = getYear(day),
                    moment = $.fullCalendar.formatDate($('#calendar').fullCalendar('getDate'), "yyyy-MM-dd"),
                    curMonth = getMonth(moment),
                    curYear = getYear(moment);

                if (parseInt(moment.slice(-2)) != 1) {
                    moment = moment.slice(0, 8) + '01';
                }

                if (day == moment) {
                    var temp = $('<div class="fc-month-number">' + curMonth + '月</div>');
                    $(cell).find('.fc-day-number').after(temp);
                }

                if (month == curMonth) {
                    curDateArr.push({
                        month: month,
                        cell: cell
                    });
                }

                if (month < curMonth) {
                    if (curMonth == 12 && month == 1) {
                        nextDateArr.push({
                            month: month,
                            cell: cell
                        });
//                        $(cell).css('background-color', '#f2f2f2');
                    } else {
                        prevDateArr.push({
                            month: month,
                            cell: cell
                        });
                    }
                }

                if (month > curMonth) {
                    if (curMonth == 1 && month == 12) {
                        prevDateArr.push({
                            month: month,
                            cell: cell
                        });
                    } else {
                        nextDateArr.push({
                            month: month,
                            cell: cell
                        });
//                        $(cell).css('background-color', '#f2f2f2');
                    }
                }
            },
            events: function (start, end, callback) {
                //添加月份标记
                addMonthTag(prevDateArr, curDateArr, nextDateArr);
                prevDateArr = [];
                curDateArr = [];
                nextDateArr = [];
                //渲染日报节点
                $("#calendar").fullCalendar('removeEvents');
                var startTime = $.fullCalendar.formatDate(start, "yyyy-MM-dd"),
                    endTime = $.fullCalendar.formatDate(end, "yyyy-MM-dd");


                $.ajax({
                    url: "${ctx}/${type}/getDailies",
                    async: false,
                    data: {
                        startTime: startTime,
                        endTime: endTime
                    },
                    dataType: "json",
                    success: function (data) {
                        datas = data;
                    }
                });


                var count = 1;
                while (start < end) {
                    startTime = $.fullCalendar.formatDate(start, "yyyy-MM-dd");
                    if (start > new Date()) {
                        break;
                    }
                    var daymis = 24 * 3600 * 1000;
                    //通过startTime,endTime请求获取日报填写情况
                    //假设datas为请求到的数据
                    var flag = false;
                    var temp = {};
                    $.each(datas, function (index, val) {
                        if (startTime === val.time) {
                            temp.id = val.id;
                            temp.title = ' ';
                            temp.start = val.time;
                            temp.end = val.time;
                            temp.hasRecord = val.hasRecord;
                            temp.url = "${ctx}/${type}/show?time=" + startTime;
                            temp.allDay = true;
                            temp.editable = false;
                            temp.className = 'fc-event-hasRecord';

                            flag = true;
                            return false;
                        }
                    });

                    if (flag) {
                        $("#calendar").fullCalendar('renderEvent', temp, true); //把从后台取出的数据进行封装以后在页面上以fullCalendar的方式进行显示
                    } else {
                        temp.id = count;
                        temp.title = ' ';
                        temp.start = startTime;
                        temp.end = startTime;
                        temp.hasRecord = false;
                        temp.url = "${ctx}/${type}/show?time=" + startTime;
                        temp.allDay = true;
                        temp.editable = false;
                        temp.className = 'fc-event-noRecord';
                        $("#calendar").fullCalendar('renderEvent', temp, false); //把从后台取出的数据进行封装以后在页面上以fullCalendar的方式进行显示
                    }
                    //天数加一
                    count++;
                    start = new Date(start.getTime() + daymis);
                }

            },
            eventAfterRender: function (calEvent, element, view) {
                var text = "填写";
                if (element.attr("class").indexOf("hasRecord") > 0) {
                    text = "修改";
                }
                var $eventinnner = element.find('.fc-event-inner');
                var $eventdetail = $('<div class="fc-event-detail">' +
                    '<div class="fc-detail-cover animation"></div>' +
                    '<div class="fc-detail-operate animation">' +
                    '<a href="' + calEvent.url + '" target="_blank">' + text + '</a>' +
                    '</div>' +
                    '</div>');
                $eventinnner.append($eventdetail);
            },
            //当鼠标悬停在一个事件上触发此操作
            eventMouseover: function (event, jsEvent, view) {
                var $target = $(jsEvent.target).closest('.fc-event');
                $target.find('.fc-event-detail').addClass('operate');
            },
            //当鼠标从一个事件上移开触发此操作
            eventMouseout: function (event, jsEvent, view) {
                var $target = $(jsEvent.target).closest('.fc-event');
                $target.find('.fc-event-detail').removeClass('operate');
            }
        });
    });

    function getYear(date) {
        var arr = date.split('-');
        return parseInt(arr[0]);
    }
    function getMonth(date) {
        var arr = date.split('-');
        return parseInt(arr[1]);
    }
    function addMonthTag(prevArr, curArr, nextArr) {
        var temp = $('<div class="fc-month-number"></div>'),
            prev = temp.clone(true),
            next = temp.clone(true);

        if (curArr.length) {
            temp.text(curArr[curArr.length - 1].month + '月');
            $(curArr[curArr.length - 1].cell).find('.fc-day-number').after(temp);
        }

        if (prevArr.length) {
            prev.text(prevArr[prevArr.length - 1].month + '月');
            $(prevArr[prevArr.length - 1].cell).find('.fc-day-number').after(prev);
        }

        if (nextArr.length) {
            next.text(nextArr[0].month + '月');
            $(nextArr[0].cell).find('.fc-day-number').after(next);
        }
    }
</script>
</body>

</html>
