<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/reportchannel<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/reportchannel">列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="button" onclick="formSubmit();">
                                <i class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/reportchannel/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue" type="button" onclick="formSubmit();"></i>&nbsp;保存</button>
                            <a href="${ctx}/reportchannel" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/reportchannel/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/reportchannel" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.city" type="hidden" value="${entity.city}"/>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="entity.creater" type="hidden" value="${entity.creater}"/>

                    <div class="row-fluid">
                        <div class="span8 control-group">
                            <label class="control-label">渠道名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name"
                                               value="${entity.name}" class="required"/>

                                        <input type="hidden" id="entity.createTimeStr"
                                               name="entity.createTimeStr"
                                               value="<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>

                                        <font color="red"><form:errors path="reportChannelVo.entity.name"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span8 control-group">
                            <label class="control-label">渠道类型:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select id="channelType" name="entity.channelType" onchange="changeDept()">
                                            <option value="1"
                                                    <c:if test="${'1' eq entity.channelType}">selected="selected"</c:if>>
                                                365渠道
                                            </option>
                                            <option value="2"
                                                    <c:if test="${'2' eq entity.channelType}">selected="selected"</c:if>>
                                                非365渠道
                                            </option>
                                        </select>

                                        <font color="red"><form:errors
                                                path="reportChannelVo.entity.channelType"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                            <c:choose>
                                                <c:when test="${'1' eq entity.channelType}">
                                                    365渠道
                                                </c:when>
                                                <c:when test="${'2' eq entity.channelType}">
                                                    非365渠道
                                                </c:when>
                                            </c:choose>
                                                    &nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span8 control-group">
                            <label class="control-label">状态:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select id="entity.status" name="entity.status">
                                            <option value="1"
                                                    <c:if test="${'1' eq entity.status}">selected="selected"</c:if>>
                                                启用
                                            </option>
                                            <option value="2"
                                                    <c:if test="${'2' eq entity.status}">selected="selected"</c:if>>
                                                禁用
                                            </option>
                                        </select>

                                        <font color="red"><form:errors
                                                path="reportChannelVo.entity.status"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                            <c:choose>
                                                <c:when test="${'1' eq entity.status}">
                                                    启用
                                                </c:when>
                                                <c:when test="${'2' eq entity.status}">
                                                    禁用
                                                </c:when>
                                            </c:choose>
                                                    &nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid" id="deptDiv">
                        <div class="span8 control-group">
                            <label class="control-label">绑定部门:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select name="department" id="department" class="span10 nochosen  multiselect"
                                                multiple="multiple"
                                                data-placeholder="请选择部门">
                                            <c:forEach items="${departmentList}" var="d">
                                                <option value="${d.id}"
                                                        <c:if test="${'1' eq d.type}">selected="selected"</c:if>>${d.name}</option>
                                            </c:forEach>
                                        </select>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${depts}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <input type="hidden" id="departmentIds" name="departmentIds" value="${departmentIds}"/>
    <input type="hidden" id="departmentNames" name="departmentNames" value="${departmentNames}"/>
</form>


<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#department').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 600,
            numberDisplayed: 2,
            filterPlaceholder: '请输入部门名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择部门 ';
                } else if (options.length > 8) {
                    return ' 选中 ' + options.length + '项';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }

            },
            optionLabel: function (element) {
                return $(element).html();
            },
            onInitialized: function (select, container) {
//                var selectedOptions = $('#department option:selected');

//                if (selectedOptions.length >= 5) {
//                    var nonSelectedOptions = $('#department option').filter(function () {
//                        return !$(this).is(':selected');
//                    });
//
//                    var dropdown = $('#department').siblings('.multiselect-container');
//                    nonSelectedOptions.each(function () {
//                        var input = $('input[value="' + $(this).val() + '"]');
//                        input.prop('disabled', true);
//                        input.parent('li').addClass('disabled');
//                    });
//                }
//                else {
                $('#department option').each(function () {
                    var input = $('input[value="' + $(this).val() + '"]');
                    input.prop('disabled', false);
                    input.parent('li').addClass('disabled');
                });
//                }
            },
            onChange: function (option, checked) {
//                var selectedOptions = $('#department option:selected');
//                if (selectedOptions.length >= 5) {
//                    var nonSelectedOptions = $('#department option').filter(function () {
//                        return !$(this).is(':selected');
//                    });
//
//                    var dropdown = $('#department').siblings('.multiselect-container');
//                    nonSelectedOptions.each(function () {
//                        var input = $('input[value="' + $(this).val() + '"]');
//                        input.prop('disabled', true);
//                        input.parent('li').addClass('disabled');
//                    });
//                } else {
                $('#department option').each(function () {
                    var input = $('input[value="' + $(this).val() + '"]');
                    input.prop('disabled', false);
                    input.parent('li').addClass('disabled');
                });
//                }
            }
        });


        changeDept();

    });

    function formSubmit() {
        var tmp = ",";
        var tmpName = ",";
        $("#department").find("option:selected").each(function () {
            tmp = tmp + $(this).val() + ",";
            tmpName = tmpName + $(this).text() + ",";
        });
        if (tmp == "," && "1" == $("#channelType").val()) {
            House365Util.createModal("请选择", "请选择部门", function () {
            });
            return;
        }

        $("#departmentNames").val(tmpName);
        $("#departmentIds").val(tmp);
        $('#input_form').submit();
    }

    function changeDept() {
        var channelType = $("#channelType").val();
        if ("2" == channelType) {
            $("#deptDiv").hide();
        }else{
            $("#deptDiv").show();
        }
    }

</script>

</body>

</html>
