<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>外部客户</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>

<style>
    .dataTables_info {
        position: absolute;
        right: 753px;
        top: 77px;
    }

    .inputSearch {
        margin-right: 20px;
    }

    .table-complex {
        background-color: #f9f9f9;
    }

    .table-star {
        background-color: #FFEB3B;
    }

    .lastChoseCustomer {
        background-color: #91bfbf;
    }

    .numbers {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .font-blue-sharp {
        color: #5C9BD1 !important;
    }

    .dashboard-stat2 {
        -webkit-border-radius: 2px;
        -moz-border-radius: 2px;
        -ms-border-radius: 2px;
        -o-border-radius: 2px;
        border-radius: 2px;
        background: #eff3f8;
        padding: 15px 15px 30px;
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .number {
        float: left;
        display: inline-block;
    }

    .dashboard-stat2 .display .number small {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .dashboard-stat2 .display .number h5 {
        margin: 0 0 2px;
        padding: 0;
        font-size: 20px;
        font-weight: 400;
    }

    .dashboard-stat2, .dashboard-stat2 .display {
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .icon {
        display: inline-block;
        float: right;
        padding: 0;
    }

    .dashboard-stat2 .display .icon > i {
        color: #cbd4e0;
        font-size: 26px;
    }

    input[type='text'] {
        margin-right: 15px;
    }

    .num3 {
        background: green;
        color: #fff;
        padding: 1px 6px;
        border-radius: 10px;
    }

    .tag-item {
        color: white;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .chosen-container {
        margin-left: 7px !important;
        width: 96px !important;
    }

    .shouc {
        position: absolute;
        right: 12px;
    }

    .table td.mangerItem.mangerlist {
        overflow: hidden;
        padding: 0;
        width: 33%;
    }

    .offset1 {
        display: none;
    }

    .mangerId_num.mine {
        width: auto !important;
        min-width: 60px;
    }

    .mangerId_name {
        margin-left: 0px;
    }

    .mangerId_name, .mangerId_content, .mangerId_state {
        width: 22.5%;
        text-align: center;
    }
    .mangerId_content{
        width: 30%;
    }

    .mangerlist__date {
        width: 30%;
    }

    .mangerlist__item {

    }

    .mangerlist__txt {
        width: 28%;
        margin-left: 120px;
    }

    .table td.mangerItem.mangerOperate {
        width: 82%;
        left: 53px;
    }

    .mangerOperate__time {
        top: 38px;
    }
    .mangerId_phone{
        text-align: left;
    }
</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                外部客户列表
            </li>
            <li style="float: right;margin-top: -5px;">
                <button type="button" class="btn btn-default"
                        onclick="window.open('${ctx}/externalCustomer/toAdd','_blank')">添加客户
                </button>
            </li>
        </ul>
    </div>
</div>

<form id="filterForm" class="form-inline filterForm" action="${ctx}/externalCustomer/list" method="get"
      style="margin: 11px 0 6px 0;">
    <div class="row-fluid"
         style="border-style: solid;border-width: thin;border-color: #d5d5d5;padding: 20px;margin-bottom: 20px;line-height: 43px;">
        <div class="span12">
            添加时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                         name="search_createTimeStart"
                         id="search_createTimeStart" value="${param['search_createTimeStart']}"
                         class="m-wrap small span2">
            至
            <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                   name="search_createTimeEnd"
                   id="search_createTimeEnd" value="${param['search_createTimeEnd']}"
                   class="m-wrap small span2">
            回访时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                         name="search_lastCallTimeStart"
                         id="search_lastCallTimeStart" value="${param['search_lastCallTimeStart']}"
                         class="m-wrap small span2">
            至
            <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                   name="search_lastCallTimeEnd"
                   id="search_lastCallTimeEnd" value="${param['search_lastCallTimeEnd']}"
                   class="m-wrap small span2">

            购房意向状态：
            <select style="width: 6rem" name="search_buyIntention" id="search_buyIntention">
                <option value="">
                    全部
                </option>
                <option value="1"
                        <c:if test="${'1' eq param['search_buyIntention']}">selected="selected"</c:if>>
                    A
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_buyIntention']}">selected="selected"</c:if>>
                    B
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_buyIntention']}">selected="selected"</c:if>>
                    C
                </option>
                <option value="4"
                        <c:if test="${'4' eq param['search_buyIntention']}">selected="selected"</c:if>>
                    D
                </option>
                <option value="5"
                        <c:if test="${'5' eq param['search_buyIntention']}">selected="selected"</c:if>>
                    E
                </option>
            </select>&nbsp;&nbsp;&nbsp;&nbsp;

            <br/>

            <span id="createTimeRecentSeven"
                  style="cursor: pointer;<c:if test="${'2' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('2')">近7天</span>&nbsp;&nbsp;
            <span id="createTimeRecentThirty"
                  style="cursor: pointer;<c:if test="${'1' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('1')">30天</span>&nbsp;&nbsp;
            <span id="createTimeAll"
                  style="cursor: pointer;<c:if test="${'0' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('0')">全部</span>&nbsp;&nbsp;
            &nbsp;&nbsp;

            <br/>
            客户姓名：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_name"
                        name="search_name" value="${param['search_name']}"
                        class="m-wrap small" placeholder="客户姓名">&nbsp;&nbsp;&nbsp;&nbsp;
            客户手机：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_phone"
                        name="search_phone" value="${param['search_phone']}"
                        class="m-wrap small" placeholder="客户手机">&nbsp;&nbsp;&nbsp;&nbsp;
            置业顾问：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_managerName"
                        name="search_managerName" value="${param['search_managerName']}"
                        class="m-wrap small" placeholder="置业顾问">&nbsp;&nbsp;&nbsp;&nbsp;
            回访记录：<input type="text" id="search_remark" style="border: 1px solid #d5d5d5;"
                        name="search_remark" value="${param['search_remark']}"
                        class="m-wrap small" placeholder="回访记录">


            <select style="width: 120px" name="search_orderByTime" id="search_orderByTime"
                    onchange="$('#filterForm').submit();">
                <option value="1"
                        <c:if test="${'1' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    添加时间降序
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    添加时间升序
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    回访时间降序
                </option>
                <option value="4"
                        <c:if test="${'4' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    回访时间升序
                </option>
            </select>
            <div style="float: right">
                <button type="button" class="btn btn-default"
                        onclick="$('#filterForm').submit();">搜索
                </button>&nbsp;&nbsp;&nbsp;&nbsp;
                <button type="button" class="btn btn-default"
                        onclick="resetForm()">重置
                </button>
                <input type="hidden" id="timePeriod" name="timePeriod" value="${timePeriod}"/>
            </div>
        </div>
    </div>

</form>


<table class="table table-advance mine">
    <tbody>
    <c:forEach items="${dataList}" var="customer" varStatus="vs">
        <tr id="customerId_${customer.id}" class="header expand">
            <td class="mangerId mangerItem mine" style="width: 32%">
                <div class="mangerItem__border"></div>
                <input type="checkbox" name="memberCheck" value="${customer.id}">
                <span class="mangerId_num mine">${customer.id}</span>
                <span class="mangerId_name">
                       <c:if test="${null ne customer.name && '' ne customer.name}">
                           <c:choose>
                               <c:when test="${fn:length(customer.name) > 3}">
                                   <c:out value="${fn:substring(customer.name, 0, 3)}..."/>
                               </c:when>
                               <c:otherwise>
                                   <c:out value="${customer.name}"/>
                               </c:otherwise>
                           </c:choose>
                       </c:if>
                       <c:if test="${null eq customer.name || '' eq customer.name}">
                           &nbsp;
                       </c:if>
                </span>
                <div class="mangerId_content">
                    <div class="mangerId_phone">
                        <c:if test="${null ne customer.phone && '' ne customer.phone}">
                            <a href="javascript:void(0)" onclick="getCRM(${customer.id})"><c:out
                                    value="${customer.phone}"/></a>
                        </c:if>
                        <c:if test="${null eq customer.phone || '' eq customer.phone}">
                            &nbsp;
                        </c:if>
                        <c:if test="${hasPhone == 1}">
                                <span id="star" class="icon-phone-sign"
                                      onclick="callCustomer('${customer.phone}','${customer.managerId}', '${customer.id}','${customer.buyIntention}','0')"></span>
                        </c:if>
                    </div>

                    <div class="mangerId_person">
                        <div class="mangerId_avar">
                            <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                                <c:out value="${customer.managerName}"/>
                            </c:if>
                            <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                                &nbsp;
                            </c:if>
                        </div>
                        <div class="mangerId_up">
                            <c:choose>
                                <c:when test="${customer.buyIntention eq '1'}">
                                    A
                                </c:when>
                                <c:when test="${customer.buyIntention eq '2'}">
                                    B
                                </c:when>
                                <c:when test="${customer.buyIntention eq '3'}">
                                    C
                                </c:when>
                                <c:when test="${customer.buyIntention eq '4'}">
                                    D
                                </c:when>
                                <c:when test="${customer.buyIntention eq '5'}">
                                    E
                                </c:when>
                                <c:otherwise>
                                    待定
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </div>
                </div>
                <div class="mangerId_state">
                    <c:if test="${not empty customer.traceStatus}">
                        <c:choose>
                            <c:when test="${customer.traceStatus eq '1'}">
                                <span class="inline">有效</span>
                            </c:when>
                            <c:when test="${customer.traceStatus eq '2'}">
                                <span class="inline">已购</span>
                            </c:when>
                            <c:when test="${customer.traceStatus eq '3'}">
                                <span class="inline">我购</span>
                            </c:when>
                            <c:when test="${customer.traceStatus eq '4'}">
                                <span class="inline">暂缓</span>
                            </c:when>
                        </c:choose>
                    </c:if>
                    <c:if test="${empty customer.traceStatus}">
                    </c:if>
                </div>
            </td>
            <td class="mangerlist mangerItem" style="width: 42%">
                <c:if test="${0 ne fn:length(customer.callbackLogEntities)}">
                    <div class="mangerlist__txt" style="text-indent:0">
                        <div class="mangerlist__item">
                            <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                       varStatus="index">
                                <p>
                                    <c:if test="${empty callbackLog.content && index.count<=3}">
                                        <c:if test="${empty callbackLog.callRecordId}">
                                            [电话已拨，但未接通或被挂断]
                                        </c:if>
                                        <c:if test="${not empty callbackLog.callRecordId && index.count<=3}">
                                            [语音记录]
                                        </c:if>
                                    </c:if>
                                    <c:if test="${not empty callbackLog.content && index.count<=3}">
                                        <c:choose>
                                            <c:when test="${fn:length(callbackLog.content) > 10}">
                                                <c:out value="${fn:substring(callbackLog.content, 0, 10)}..."/>
                                            </c:when>
                                            <c:otherwise>
                                                <c:out value="${callbackLog.content}"/>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:if>
                                </p>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="mangerlist__date">
                        <div class="mangerlist__dateC">
                            <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                       varStatus="index">
                                <p><c:if test="${index.count<=3}">
                                    <f:formatDate value='${callbackLog.createTime}' pattern='MM-dd HH:mm'/>
                                </c:if>
                                </p>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="mangerlist__record" onclick="showCustomerCallbackLogs('${customer.id}')">
                        查看回访记录
                    </div>
                </c:if>
                <c:if test="${0 eq fn:length(customer.callbackLogEntities)}">
                    <div class="mangerlist__txt">
                        <div class="mangerlist__item">
                            暂无回访记录！
                        </div>
                    </div>
                    <div class="mangerlist__date">
                        <div class="mangerlist__dateC">
                        </div>
                    </div>
                </c:if>
                <div class="mangerItem__border"></div>
            </td>

            <td class="mangerItem mangerOperate" style="display: table;padding: 0;overflow:visible;">
                <div class="mangerOperate__time" style="right:0px">
                    <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                        <f:formatDate value='${customer.createTime}'
                                      pattern='MM-dd HH:mm'/>
                    </c:if>
                    <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                        &nbsp;
                    </c:if>
                </div>
                <div style="display: table-cell;vertical-align: middle">
                    <shiro:hasPermission name="FUNC:ADDCALL">
                        <div class="mangerOperate__add"
                             onclick="addCallBack('${customer.id}','${customer.phone}','${customer.buyIntention}')">
                            添加回访
                        </div>
                    </shiro:hasPermission>
                    <div class="mangerOperate__detail" onclick="customerInfo(${customer.id})">查看详情</div>
                </div>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="row-fluid" style="position: relative">
    <house365:newPagination page="${page}"/>
</div>

<script type="text/html" id="customerCallbackLogsTemplate">
    <div class="returnWinList">
        {{if callbackLogs.length !=0}}
        {{each callbackLogs as log index}}
        <div class="returnWinItem">
            <div class="returnWinItem__txt">
                {{if log.content != "" && log.content != null}}
                {{log.content}}
                {{/if}}
                {{if log.callRecordId != "" && log.callRecordId != null}}
                <audio controls>
                    <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path={{log.callRecordName}}">
                    Your browser does not support this audio format.
                </audio>
                {{/if}}
                {{if (log.content == "" || log.content == null)}}
                {{if (log.callRecordId == "" || log.callRecordId == null)}}
                [电话已拨，但未接通或被挂断]
                {{/if}}
                {{if (log.callRecordId != "" && log.callRecordId != null)}}
                [语音记录]
                {{/if}}
                {{/if}}
            </div>
            <div class="returnWinItem__name" style="width:222px;top:35px;margin-left:-60px;">{{log.managerName}}</div>
            <div class="returnWinItem__date" style="width:222px;top:35px;margin-left:-60px;">{{log.createTime |
                dateFormat:'yyyy-MM-dd hh:mm:ss'}}
            </div>
            {{/each}}
            {{else}}
            暂无回访记录
            {{/if}}
        </div>
    </div>
</script>

<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/template.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/utils.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.waypoints.min.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.counterup.min.js"></script>

<script language="javascript" type="text/javascript">
    Date.prototype.pattern = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours() % 12 == 0 ? 12 : this.getHours() % 12, //小时
            "H+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        var week = {
            "0": "/u65e5",
            "1": "/u4e00",
            "2": "/u4e8c",
            "3": "/u4e09",
            "4": "/u56db",
            "5": "/u4e94",
            "6": "/u516d"
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "/u661f/u671f" : "/u5468") : "") + week[this.getDay() + ""]);
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    }
</script>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script type="text/javascript">

    var enterFlag = 0;
    $(document).keydown(function (event) {
        var style = document.getElementById("modal_dialog").style.display;
        if (style == 'block') {
            enterFlag = 1;
        } else {
            enterFlag = 0;
        }
        if (enterFlag == 0 && event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    var lastChoseCustomerId = getCookie("lastChoseCustomerId");

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    });

    $(function () {
        $('.counter').counterUp({
            delay: 100,
            time: 2000
        });
        $("#customerId_" + lastChoseCustomerId).addClass("lastChoseCustomer");

        // 初始化添加时间
        if ($('#timePeriod').val() == '0') {
            createTimeClick('0');
        }

        // 添加时间
        var createTimeStart = $("#search_createTimeStart");
        var createTimeEnd = $("#search_createTimeEnd");
        createTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: createTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });
        createTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: createTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: createTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_createTimeEnd'
                    })
                }
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });

        // 回访时间
        var lastCallTimeStart = $("#search_lastCallTimeStart");
        var lastCallTimeEnd = $("#search_lastCallTimeEnd");
        lastCallTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: lastCallTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        lastCallTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: lastCallTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: lastCallTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_lastCallTimeEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                },
                position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });

        $('.header').each(function () {
            $(this).nextUntil('tr.header').hide();
        });

        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

    });

    function resetForm() {
        $("#createTimeRecentSeven").css("color", "#000000");
        $("#createTimeRecentThirty").css("color", "#000000");
        $("#createTimeAll").css("color", "#30A3DE");

        // 重置form
        $("#filterForm")[0].reset();

        $("#search_name").val('');
        $("#search_phone").val('');
        $("#search_bakPhone").val('');

        $("#search_managerName").val('');
        $("#search_createTimeStart").val('');
        $("#search_createTimeEnd").val('');
        $("#search_lastCallTimeStart").val('');
        $("#search_lastCallTimeEnd").val('');

        $("#search_remark").val('');
        // 重置购房意向状态下拉框
        $("#search_buyIntention").val("");
        $("#search_buyIntention").trigger('chosen:updated');

        // 重置添加时间 近7天 开始时间结束时间
        createTimeClick('0');
    }

    function sortCreateTime() {
        var mode = $("#sort_createTime").val();
        if (mode == 'desc') {
            mode = 'asc';
        } else if (mode == 'asc') {
            mode = 'desc';
        } else if (mode == '' || mode == undefined) {
            mode = 'desc';
        }
        $("#sort_createTime").val(mode);

        $("#filterForm").submit();
    }

    function showCustomerCallbackLogs(customerId) {
        setCookie("lastChoseCustomerId", customerId);
        $.ajax({
            url: '${ctx}/externalCustomer/getCustomerCallbackLogs',
            data: {
                "customerId": customerId
            },
            type: "GET",
            success: function (data) {

                var callContentHtml = template('customerCallbackLogsTemplate', {
                    ctx: "${ctx}",
                    callbackLogs: data
                });
                House365Util.createModal("回访记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function createTimeClick(createTimeType) {
        var timeStart, timeEnd;
        var myDate = new Date();
        $("#timePeriod").val(createTimeType);

        switch (createTimeType) {
            case "2":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 7 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#30A3DE");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "1":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 30 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#30A3DE");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "0":
                timeEnd = "";
                timeStart = "";
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#30A3DE");
                break;
            default:
                break;
        }
        $("#search_createTimeStart").val(timeStart);
        $("#search_createTimeEnd").val(timeEnd);
    }

    function customerInfo(id) {
        setCookie("lastChoseCustomerId", id);
        window.open("/house365-hgs-web/externalCustomer/toEdit/" + id, "_blank");
    }

    //读取cookies
    function getCookie(name) {
        var arr, reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
        if (arr = document.cookie.match(reg))
            return unescape(arr[2]);
        else
            return null;
    }

    //写cookies
    function setCookie(name, value) {
        $(".lastChoseCustomer").removeClass("lastChoseCustomer");
        $("#customerId_" + value).addClass("lastChoseCustomer");
        var Days = 30;
        var exp = new Date();
        exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
        document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
    }

    var curnet = "${sessionUser.cornet}";
    function callCustomer(memPhone, managerId, customerId, buyIntention, abandon) {
        $.ajax({
            url: "${ctx}/cityCall/judgeCall",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {

                    if (curnet == "") {
                        House365Util.createModal("电话回访",
                            "对不起，您尚未填写固定电话短号，请前往个人中心设置", function () {
                                window.location.href = "${ctx}/role/edit/${sessionUserId}";
                            }, "前往设置");
                        return;
                    }
                    $("#callDialog").load("${ctx}/externalCustomer/callCustomer?memPhone=" + memPhone + "&customerId=" + customerId
                        + "&buyIntention=" + buyIntention + "&abandon=" + abandon, null, function () {
                    });
                    $("#callDialog").dialog({
                        closeOnEscape: false,
                        autoOpen: false,
                        draggable: false,
                        modal: true,
                        open: function (event, ui) {
                            $(".ui-dialog-titlebar-close", $(this).parent()).hide();
                        },
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        },
                        width: 600
                    }).dialog("open");
                }
            }
        });
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/externalCustomer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    var callId;
    function addCallBack(_customerId, _phone, _buyIntention) {
        $("#myModal").hide();
        callId = _customerId;
        setCookie("lastChoseCustomerId", _customerId);

        var callContentHtml = "";
        callContentHtml += "<div class='row-fluid' ><div class='span5 control-group' style='position: relative'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls' style='position: absolute;top: -4px;left: 74px'><select name='entity.buyIntention' id='buyIntention'>"
            + "<option value=''";
        if (_buyIntention == "" || _buyIntention == null) {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">请选择</option><option value='1'";
        if (_buyIntention == "1") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">A</option><option value='2'";
        if (_buyIntention == "2") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">B</option><option value='3'";
        if (_buyIntention == "3") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">C</option><option value='4'";
        if (_buyIntention == "4") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">D</option><option value='5'";
        if (_buyIntention == "5") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">E</option>";
        callContentHtml += "</select>";

        callContentHtml += "</div></div></div>";

        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'  style='width: 100%;position: relative;'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<p contenteditable='true' class='temp' cols='10' rows='5' style='margin: 0px 0px 10px;left:81px; width: 436px; height: 70px;' id='cusinfo' name='cusinfo'>" +
            "<div style='position: absolute;bottom: 39px;width: 400px;left:90px'>" +

            "</div></p></div>";

        House365Util.createModal("添加回访", callContentHtml, function () {
            var callContent = $("#cusinfo").text().replace(/(^\s*)|\s*$/g, '');
            var buyIntention = $("#buyIntention").val();
            var customerId = _customerId;

            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }
            $("#hiddenBuyIntention").val(buyIntention);
            if (!callContent || callContent == "") {
                alert("回访内容不能为空");
                return false;
            } else if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/externalCustomer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": customerId,
                        "buyIntention": buyIntention
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            window.location.reload();
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
            }
        });
    }

</script>
<div id="callDialog" style="display: none" title="电话回访">

</div>

</body>
</html>
