<%@ page language="java" pageEncoding="UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<html>
<head>
    <title>电话回访</title>
    <script language="javascript" type="text/javascript"
            src="${ctx}/resources/script/jquery/jquery-1.10.2.min.js"></script>
    <script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
    <!-- 日历控件脚本 -->
    <script type="text/javascript"
            src="${static_common}/script/bootstrap-datetimepicker-master/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript"
            src="${static_common}/script/bootstrap-datetimepicker-master/js/locales/bootstrap-datetimepicker.zh-CN.js"></script>
    <style>
        .temp {
            border: 1px solid #cccccc;
            width: 450px !important;
            height: 160px !important;
            position: relative;
            top: -26px;
            left: 71px;
        }

        .bat1 {
            padding: 0 10px;
            background-color: white;
            border-radius: 5px;
            outline: 0;
            border-color: transparent;
            box-shadow: none;
            margin: 0 5px;
            display: inline-block;
            height: 30px;
            line-height: 30px;
        }

        .color_999 {
            border: 1px solid #999;
            color: #999;
        }

        .color_d9534f {
            border: 1px solid #d9534f;
            color: #d9534f;
        }

        .color_f0ad4e {
            border: 1px solid #f0ad4e;
            color: #f0ad4e;
        }

        .color_5cb85c {
            border: 1px solid #5cb85c;
            color: #5cb85c;
        }

        .color_5bc0de {
            border: 1px solid #5bc0de;
            color: #5bc0de;
        }

        .color_0275d8 {
            border: 1px solid #0275d8;
            color: #0275d8;
        }

        .color_663399 {
            border: 1px solid #663399;
            color: #663399;
        }

        .bt_last {
            background-color: #f0f0f0 !important;
            border: none !important;
            background-image: none !important;
        }

        .bt_close {
            background-color: white;
            border: 1px solid black;
            border-radius: 5px;
            padding: 5px 20px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
<div id="callTable">
    <p>您填写的短号为：${sessionUser.cornet}</p>
    <p>是否拨打？</p>
    <button id="calling">是</button>
    <button id="cancel">取消</button>
</div>
<div id="callingCompleted" style="display: none">
    回访电话拨打完成！
    <button id="completed">结束</button>
</div>
<div id="callingTable" style="display: none; width: 500px">
    <p>呼叫成功！电话正在拨通：<span id="callingTime">00 : 00</span></p>

    <div>
        <span>客户意向：</span>
        <select style="width: 6rem;margin-top: 12px" name="buyIntention" id="buyIntentionNew">
            <option value=""
                    <c:if test="${'' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                请选择
            </option>
            <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                <c:if test="${dict.dicValue < 5}">
                    <option value="${dict.dicValue}"
                            <c:if test="${dict.dicValue == buyIntention}">selected</c:if>>${dict.dicName}</option>
                </c:if>
            </c:forEach>
            <option value="5" <c:if test="${5 == buyIntention}">selected</c:if>>E</option>
        </select>
    </div>
    <div style="position: relative;">
        <input type="hidden" id="callbackLogId"/>
        <div class='row-fluid'>
            <label class='control-label'>回访内容：</label>
            <div class="span5 control-group" style="width: 100%;position: relative;top:3px">

                <p contenteditable="true" class="temp" cols="10" rows="5"
                   style="margin: 0px 0px 10px; width: 436px; height: 70px;" id="callContent" name="callContent">
                </p>
            </div>
        </div>

        <button id="hangup" class="bt_close" style="margin-left: 80px">挂断</button>
    </div>
</div>

</body>

<script type="text/javascript">
    var type;
    var abandon = ${abandon};
    if (abandon == 0) {
        type = 1
    } else if (abandon == 1) {
        type = 0
    }

    $(function () {
        method.init();
    });

    var method = {
        timer: 1,
        memphone: "${memPhone}",
        customerId: "${customerId}",
        minute: 0,
        second: 0,
        init: function () {
            method.bindEvent();
        },
        bindEvent: function () {
            var _this = this;
            $('#calling').click(function () {
                if (!$(this).hasClass('calling')) {
                    $(this).removeClass('calling').text('拨打中...');
                    _this.calling();
                }
            });
            $('#hangup').click(function () {
                _this.hangup();

            });
            $('#abandon').click(function () {
                _this.abandon();
            });
            $('#completed').click(function () {
                $(".ui-dialog").hide();
                $(".ui-widget-overlay").hide();
                window.location.reload(true);
            });
            $('#cancel').click(function () {
                $(".ui-dialog").hide();
                $(".ui-widget-overlay").hide();
//                window.location.reload(true);
            });
        },
        calling: function () {
            $('#calling').off();
            $.ajax({
                url: "${ctx}/externalCustomer/calling",
                data: {
                    memPhone: method.memphone,
                    customerId: method.customerId
                },
                type: "get",
                dataType: 'json',
                success: function (callbackLogId) {
                    $("#callTable").hide();
                    $("#callingTable").show();
                    $("#callbackLogId").val(callbackLogId);
                    method.timeInterval();
                },
                error: function () {
                    House365Util.createModal("电话回访",
                        "呼叫失败!请重新尝试或联系管理员", function () {
                        });
                }
            });
        },
        hangup: function () {
            var customerId = "${customerId}";

            var buyIntention = $("#buyIntentionNew").val();

            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }
            var callContent = $("#callContent").text().replace(/(^\s*)|\s*$/g, '');
            if (!callContent || callContent == "") {
                alert("回访内容不能为空");
                return;
            }

            $.ajax({
                url: "${ctx}/externalCustomer/handUp",
                type: "get",
                data: {
                    memPhone: method.memphone,
                    callbackLogId: $("#callbackLogId").val(),
                    callContent: callContent,
                    oldCustomerId: customerId,
                    buyIntention: buyIntention
                },
                success: function () {
                    $("#callingTable").hide();
                    $("#callingCompleted").show();
                }
            });
        },
        timeInterval: function () {
            method.timer = setInterval(function () {
                method.second = method.second + 1;
                if (method.second >= 60) {
                    method.second = 0;
                    method.minute = method.minute + 1;
                }
                var minute, second;
                if (method.minute < 10) {
                    minute = "0" + method.minute;
                } else {
                    minute = method.minute;
                }
                if (method.second < 10) {
                    second = "0" + method.second;
                } else {
                    second = method.second;
                }
                $("#callingTime").html(minute + " : " + second);
            }, 1000);
        }
    };

</script>
</html>
