<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <c:if test="${not empty managerName}">
        <title>${managerName}的客户</title>
    </c:if>
    <c:if test="${empty managerName}">
        <title>我的客户</title>
    </c:if>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<style>
    .container-fluid {
        min-width: 1440px;
    }

    .dataTables_info {
        position: absolute;
        right: 753px;
        top: 77px;
    }

    .inputSearch {
        margin-right: 20px;
    }

    .table-complex {
        background-color: #ddd;
    }

    .table-star {
        background-color: #FFEB3B;
    }

    .lastChoseCustomer {
        background-color: #91bfbf;
    }

    .numbers {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .font-blue-sharp {
        color: #5C9BD1 !important;
    }

    .dashboard-stat2 {
        -webkit-border-radius: 2px;
        -moz-border-radius: 2px;
        -ms-border-radius: 2px;
        -o-border-radius: 2px;
        border-radius: 2px;
        background: #eff3f8;
        padding: 15px 15px 30px;
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .number {
        float: left;
        display: inline-block;
    }

    .dashboard-stat2 .display .number small {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .dashboard-stat2 .display .number h5 {
        margin: 0 0 2px;
        padding: 0;
        font-size: 20px;
        font-weight: 400;
    }

    .dashboard-stat2, .dashboard-stat2 .display {
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .icon {
        display: inline-block;
        float: right;
        padding: 0;
    }

    .dashboard-stat2 .display .icon > i {
        color: #cbd4e0;
        font-size: 26px;
    }
</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                <c:if test="${not empty managerName}">
                    ${managerName}的客户
                </c:if>
                <c:if test="${empty managerName}">
                    我的客户
                </c:if>
            </li>
        </ul>
    </div>
</div>

<!-- 面包屑 begin -->
<div class="row-fluid">

    <div class="span6">
        <div class="dashboard-stat2 ">
            <div class="display">
                <div class="number">
                    <h5 class="font-blue-sharp">
                        <span class="counter" data-counter="counterup" data-value="${summary['allCount']}">0</span>
                    </h5>
                    <small>累计客户:累计处理过的客户总量，包含已经删除和丢回公海的数据</small>
                </div>
                <div class="icon">
                    <i class="icon-pie-chart"></i>
                </div>
            </div>
        </div>
        <div class="dashboard-stat2 ">
            <div class="display">
                <div class="number">
                    <h5 class="font-blue-sharp">
                        <span style="font-size: 12px;color: #AAB5BC;">今日</span>
                        <span class="counter" data-counter="counterup"
                              data-value="${todayTotalCall+todayAllCall+todayTotalAbandon+todaynormalCall}">0</span>
                        <span style="font-size: 12px;color: #AAB5BC;">昨日</span>
                        <span class="counter" data-counter="counterup"
                              data-value="${yesterdayTotalCall+yesterdayAllCall+yesterdayTotalAbandon+yesterdayNormalCall}">0</span>
                    </h5>
                    <small>累计回访:今日、昨日处理过的累计客户数，是”电话回访、二次跟进、普通回访、放弃“之和</small>
                </div>
                <div class="icon">
                    <i class="icon-pie-chart"></i>
                </div>
            </div>
        </div>
        <div class="dashboard-stat2 ">
            <div class="display">
                <div class="number">
                    <h5 class="font-blue-sharp">
                        <span style="font-size: 12px;color: #AAB5BC;">今日</span>
                        <span class="counter" data-counter="counterup" data-value="${todayTotalCall}">0</span>
                        <span style="font-size: 12px;color: #AAB5BC;">昨日</span>
                        <span class="counter" data-counter="counterup" data-value="${yesterdayTotalCall}">0</span>
                    </h5>
                    <small>电话回访:通过“待回访”页面成功外呼的数量</small>
                </div>
                <div class="icon">
                    <i class="icon-pie-chart"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="span6">
        <div class="dashboard-stat2 ">
            <div class="display">
                <div class="number">
                    <h5 class="font-blue-sharp">
                        <span style="font-size: 12px;color: #AAB5BC;">今日</span>
                        <span class="counter" data-counter="counterup" data-value="${todayAllCall}">0</span>
                        <span style="font-size: 12px;color: #AAB5BC;">昨日</span>
                        <span class="counter" data-counter="counterup" data-value="${yesterdayAllCall}">0</span>
                    </h5>
                    <small>二次跟进:除"待回访"外的其他页面下所有被电话回访过的客户数量,仅添加文字回访的客户不算</small>
                </div>
                <div class="icon">
                    <i class="icon-pie-chart"></i>
                </div>
            </div>
        </div>
        <div class="dashboard-stat2 ">
            <div class="display">
                <div class="number">
                    <h5 class="font-blue-sharp">
                        <span style="font-size: 12px;color: #AAB5BC;">今日</span>
                        <span class="counter" data-counter="counterup" data-value="${todaynormalCall}">0</span>
                        <span style="font-size: 12px;color: #AAB5BC;">昨日</span>
                        <span class="counter" data-counter="counterup" data-value="${yesterdayNormalCall}">0</span>
                    </h5>
                    <small>普通回访:除电话回访外的其他回访总量</small>
                </div>
                <div class="icon">
                    <i class="icon-pie-chart"></i>
                </div>
            </div>
        </div>
        <div class="dashboard-stat2 ">
            <div class="display">
                <div class="number">
                    <h5 class="font-blue-sharp">
                        <span style="font-size: 12px;color: #AAB5BC;">今日</span>
                        <span class="counter" data-counter="counterup" data-value="${todayTotalAbandon}">0</span>
                        <span style="font-size: 12px;color: #AAB5BC;">昨日</span>
                        <span class="counter" data-counter="counterup" data-value="${yesterdayTotalAbandon}">0</span>
                    </h5>
                    <small>放弃:即“待回访”列表中被放弃的客户数量总和</small>
                </div>
                <div class="icon">
                    <i class="icon-pie-chart"></i>
                </div>
            </div>
        </div>
    </div>

</div>

<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/template.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/utils.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.waypoints.min.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.counterup.min.js"></script>

<script language="javascript" type="text/javascript">
    Date.prototype.pattern = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours() % 12 == 0 ? 12 : this.getHours() % 12, //小时
            "H+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        var week = {
            "0": "/u65e5",
            "1": "/u4e00",
            "2": "/u4e8c",
            "3": "/u4e09",
            "4": "/u56db",
            "5": "/u4e94",
            "6": "/u516d"
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "/u661f/u671f" : "/u5468") : "") + week[this.getDay() + ""]);
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    }
</script>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script type="text/javascript">
//    var lastChoseCustomerId = getCookie("lastChoseCustomerId");
    $(function () {
        $('.counter').counterUp({
            delay: 100,
            time: 2000
        });
    });

</script>

</body>
</html>
