<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>CrmSource列表</title>
    <style type="text/css">
        .navbar-inverse .navbar-inner {
            display: none;
        }
    </style>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">CrmSource列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/crmsource?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/crmsource" method="get">
                <input type="text" name="search_LIKE_sourceName" value="${param['search_LIKE_sourceName']}"
                       class="m-wrap small" placeholder="名称">
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">id</th>
            <th width="100">名称</th>
            <th width="100">类别ID</th>
            <th width="100">类别</th>
        </tr>
        </thead>
        <c:forEach items="${crmSources}" var="crmSource">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${crmSource.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne crmSource.sourceId && '' ne crmSource.sourceId}">
                        <c:out value="${crmSource.sourceId}"/>
                    </c:if>
                    <c:if test="${null eq crmSource.sourceId || '' eq crmSource.sourceId}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne crmSource.sourceName && '' ne crmSource.sourceName}">
                        <c:out value="${crmSource.sourceName}"/>
                    </c:if>
                    <c:if test="${null eq crmSource.sourceName || '' eq crmSource.sourceName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne crmSource.categoryId && '' ne crmSource.categoryId}">
                        <c:out value="${crmSource.categoryId}"/>
                    </c:if>
                    <c:if test="${null eq crmSource.categoryId || '' eq crmSource.categoryId}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne crmSource.categoryName && '' ne crmSource.categoryName}">
                        <c:out value="${crmSource.categoryName}"/>
                    </c:if>
                    <c:if test="${null eq crmSource.categoryName || '' eq crmSource.categoryName}">
                        &nbsp;
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript" src="${ctx}/resources/customize/js/layer.js"></script>
<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
        id为空则是多选  判断是否为空
        为空 提示选择
        不为空 确认后删除
        不为空单选确认后删除
        */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除公告", "请至少选择一条公告!", function () {
            });
        }
        else {
            House365Util.createModal("删除公告", "确定要删除该公告？", function () {
                $.ajax({
                    url: '${ctx}/crmsource/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
