<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>云迹报表详情</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>云迹报表
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>数据明细
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm" action="${ctx}/cloudactivity/cloudCusList/${id}/${status}" method="get"></form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">序号</td>
                <td width="100" style="text-align:center">姓名</td>
                <td width="100" style="text-align:center">手机号</td>
                <td width="100" style="text-align:center">安家顾问</td>
                <td width="100" style="text-align:center">到访项目</td>
                <td width="100" style="text-align:center">${timeType}</td>

                <td width="100" style="text-align:center">现有状态</td>
                <td width="100" style="text-align:center">创建人</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${i.index+1}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.name}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.phone}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.managerName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.projectName}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.occurTime && '' ne item.occurTime}">
                                <f:formatDate value='${item.occurTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.occurTime || '' eq item.occurTime}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.customerStatus}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.createName}
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>

        </table>
        <div class="row${fluid}">
            <house365:pagination page="${page}"/>
        </div>
    </div>

</div>


<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>

<script type="text/javascript">

</script>
</body>
</html>
