<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>回访录音</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                回访录音
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 end -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/callbackrecord" method="get">
                <input type="text" name="search_LIKE_keyword" value="${param['search_LIKE_keyword']}"
                       class="m-wrap small span2" placeholder="请输入关键词">
                回访时间：
                <input style="width: 6rem" type="text" name="search_GTE_createTimeStart" id="search_GTE_createTimeStart"
                       value="${param['search_GTE_createTimeStart']}"
                       class="m-wrap small span2" placeholder="开始时间">至
                <input style="width: 6rem" type="text" name="search_LTE_createTimeEnd" id="search_LTE_createTimeEnd"
                       value="${param['search_LTE_createTimeEnd']}"
                       class="m-wrap small span2" placeholder="结束时间">
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr style="background-color: #dddddd;">
            <th width="10%" style="text-align: center">序号</th>
            <th width="15%">客户姓名</th>
            <th width="15%">客户电话</th>
            <th width="30%">录音内容</th>
            <th width="15%">置业顾问</th>
            <th width="15%">回访时间</th>
        </tr>
        </thead>
        <c:forEach items="${callbackrecords}" var="customer">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <c:if test="${null ne customer.id && '' ne customer.id}">
                        ${customer.id}
                    </c:if>
                </td>
                <td style="white-space:nowrap;overflow: hidden;text-overflow:ellipsis" nowrap="nowrap">
                        <c:if test="${null ne customer.name && '' ne customer.name}">
                            <c:choose>
                                <c:when test="${fn:length(customer.name) > 6}">
                                    <c:out value="${fn:substring(customer.name, 0, 6)}..."/>
                                </c:when>
                                <c:otherwise>
                                    <c:out value="${customer.name}"/>
                                </c:otherwise>
                            </c:choose>
                        </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.phone && '' ne customer.phone}">
                        ${customer.phone}
                    </c:if>
                </td>
                <td style="white-space:nowrap;overflow: hidden;text-overflow:ellipsis" nowrap="nowrap">
                    <c:if test="${null ne customer.content && '' ne customer.content}">
                        ${customer.content}
                        <br>
                    </c:if>
                    <c:if test="${null ne customer.callRecordName && '' ne customer.callRecordName}">
                        <audio controls>
                            <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path=${customer.callRecordName}">
                            Your browser does not support this audio format.
                        </audio>
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                    ${customer.managerName}
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                        <%--${customer.createTime}--%>
                        ${fn:substring(customer.createTime,0 , 19)}
                        <%--<f:formatDate value='${customer.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>--%>
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>

    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>

<script type="text/javascript">
    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    $(function () {
        var startTime = $("#search_GTE_createTimeStart")
        var endTime = $("#search_LTE_createTimeEnd");
        endTime.bind("click", function () {
            WdatePicker({doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false});
        });
        startTime.bind("click", function () {
            WdatePicker({
                doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false,
                onpicked: function () {
                    // $("#search_LTE_createTimeEnd").click();
                    WdatePicker({
                        doubleCalendar: true,
                        startDate: "%y-{%M-1}-%d",
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_createTimeEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                }, position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });
    });

    function assignManagerSingle(obj) {

        House365Util.createRemoteModal("派工", "${ctx}/customer/assignManager?customerCount=1", null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });


            if (obj == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            checkCustomerPhone(userIds, obj);
            return true;
        });
    }

    function assignManager() {

        var customerIds = "", customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        House365Util.createRemoteModal("批量派工", "${ctx}/customer/assignManager?customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });


            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            checkCustomerPhone(userIds, customerIds);
            return true;
        });
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }


    var deleteFormOcean = function (selectedId) {
        /*
         id为空则是多选 判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除客户", "请至少选择一个客户!", function () {
            });
        }
        else {
            House365Util.createModal("删除客户", "确定要删除该客户？", function () {
                $.ajax({
                    url: '${ctx}/customer/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    function checkCustomerPhone(userIds, customerIds) {
        $.ajax({
            url: "${ctx}/customer/checkCustomerPhoneByCustomerIds",
            data: {
                userIds: userIds,
                customerIds: customerIds
            },
            async: true,
            type: "get",
            success: function (data) {
                if (data.result === "0") {
                    House365Util.createModal("提示,", data.msg + "<hr/>是否继续？", function () {
                        assignCustomer(userIds, customerIds);
                        return false;
                    });
                } else {
                    assignCustomer(userIds, customerIds);
                    return false;
                }
            }
        });
    }

    function assignCustomer(userIds, customerIds) {
        $.ajax({
            url: '${ctx}/customer/assign',
            data: {"userIds": userIds, "customerIds": customerIds},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    window.location.reload();
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }
</script>
</body>
</html>
