package com.house365.web.controller;

import com.house365.commons.system.HttpClientUtil;
import com.house365.commons.system.RestUtil;
import com.house365.rest.context.ServiceConstant;
import com.house365.web.util.MemoryPropertyPlaceholderConfigurer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 获取远程JSON请求字符串
 * Created by 365 on 2015/3/5.
 */
@Controller("remoteJson")
@RequestMapping("remoteJson")
public class RemoteJsonController {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteJsonController.class);

    /**
     * 获取JSON内容
     *
     * @param request 请求对象
     * @return JSON内容
     */
    @RequestMapping(value = "getJson", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String getJson(HttpServletRequest request, HttpSession session) {
        String result = null;
        Map<String, String[]> parameterMap = new HashMap<>();
        parameterMap.putAll(request.getParameterMap());
        String[] cities = parameterMap.get("city");
        if (ArrayUtils.isEmpty(cities) || StringUtils.isEmpty(cities[0])) {
            String cityId = (String) session.getAttribute(ServiceConstant.CITY_ID);
            if (StringUtils.isNotEmpty(cityId)) {
                parameterMap.put("city", new String[]{cityId});
            } else {
                parameterMap.put("city", new String[]{"nj"});
            }
        }
        String[] urls = parameterMap.remove("url");
        if (ArrayUtils.isNotEmpty(urls)) {
            final String url = urls[0];
            List<NameValuePair> params = new ArrayList<>();
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()[0]));
            }
            try {
                result = HttpClientUtil.doGet(url, params);
            } catch (Exception ex) {
                LOGGER.error(ex.getMessage(), ex);
            }
        }
        return result;
    }

    @RequestMapping(value = "getNewHouseConf", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String getNewHouseConf(HttpServletRequest request, HttpSession session) {
        String client = "tf";
        String channl = "app";
        String v = "6.1";
        String city = (String) session.getAttribute("city");
        String method = "newhouse.getHouseProfile";
        String url = MemoryPropertyPlaceholderConfigurer.getContextProperty("app.ad.url.production");
        List<NameValuePair> queryParams = new ArrayList<NameValuePair>(5);
        queryParams.add(new BasicNameValuePair("client", client));
        queryParams.add(new BasicNameValuePair("channl", channl));
        queryParams.add(new BasicNameValuePair("v", v));
        queryParams.add(new BasicNameValuePair("city", city));
        queryParams.add(new BasicNameValuePair("method", method));
        String result = null;
        try {
            result = RestUtil.getForString(url, queryParams);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}
