/**
 * Description: DeptSourceStatistics控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:42:11
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.DeptSourceStatisticsEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.DeptSourceStatisticsVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.DeptSourceStatisticsListRequest;
import com.house365.ws.beans.request.DeptSourceStatisticsRequest;
import com.house365.ws.beans.response.DeptSourceStatisticsListResponse;
import com.house365.ws.beans.response.DeptSourceStatisticsResponse;
import com.house365.ws.interfaces.server.IDeptSourceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * DeptSourceStatistics控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/deptsourcestatistics")
public class DeptSourceStatisticsController extends BaseController {

    /**
     * 自动注入DeptSourceStatisticsWS实现
     */
    @Autowired
    private IDeptSourceStatistics deptSourceStatistics;

    /**
     * 去新增DeptSourceStatistics
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增DeptSourceStatistics
     *
     * @param vo     DeptSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createDeptSourceStatistics(@Valid DeptSourceStatisticsVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        DeptSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                DeptSourceStatisticsRequest request = new DeptSourceStatisticsRequest();
                request.setEntity(entity);
                DeptSourceStatisticsResponse response = deptSourceStatistics
                        .addDeptSourceStatistics(request);
                Integer id = response.getEntity().getId();
                return "redirect:/deptsourcestatistics/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除DeptSourceStatistics
     *
     * @param id DeptSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    deptSourceStatistics.deleteDeptSourceStatisticsById(Integer.valueOf(ids[i]));
                }
            } else {
                deptSourceStatistics.deleteDeptSourceStatisticsById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看DeptSourceStatistics
     *
     * @param id DeptSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        DeptSourceStatisticsResponse response = deptSourceStatistics
                .getDeptSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改DeptSourceStatistics
     *
     * @param id DeptSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        DeptSourceStatisticsResponse response = deptSourceStatistics
                .getDeptSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改DeptSourceStatistics
     *
     * @param vo     DeptSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateDeptSourceStatistics(@Valid DeptSourceStatisticsVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        DeptSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                DeptSourceStatisticsRequest request = new DeptSourceStatisticsRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                DeptSourceStatisticsResponse rersponse = deptSourceStatistics
                        .updateDeptSourceStatistics(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/deptsourcestatistics/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询DeptSourceStatistics
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        DeptSourceStatisticsListRequest listRequest = new DeptSourceStatisticsListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        DeptSourceStatisticsListResponse response = deptSourceStatistics.getDeptSourceStatisticsList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("deptSourceStatisticss", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
