/**
 * Description: RushCustomerRuleDepartmentRel数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-10 上午 09:00:35
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * RushCustomerRuleDepartmentRel数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-10
 * @see
 * @since 1.0
 */
public class RushCustomerRuleDepartmentRelEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 抢客规则id
     */

    private Integer rushCustomerRuleId;

    /**
     * 部门id
     */

    private Integer departmentId;

    /**
     * 部门名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String departmentName;

    //columns END
    /*
	public RushCustomerRuleDepartmentRel(){
	}

	public RushCustomerRuleDepartmentRel(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 获取抢客规则id
     * @return 抢客规则id
     */
    public Integer getRushCustomerRuleId() {
        return this.rushCustomerRuleId;
    }

    /**
     * 设置抢客规则id
     * @param rushCustomerRuleId 抢客规则id
     */
    public void setRushCustomerRuleId(Integer rushCustomerRuleId) {
        this.rushCustomerRuleId = rushCustomerRuleId;
    }

    /**
     * 获取部门id
     * @return 部门id
     */
    public Integer getDepartmentId() {
        return this.departmentId;
    }

    /**
     * 设置部门id
     * @param departmentId 部门id
     */
    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    /**
     * 获取部门名称
     * @return 部门名称
     */
    public String getDepartmentName() {
        return this.departmentName;
    }

    /**
     * 设置部门名称
     * @param departmentName 部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("RushCustomerRuleId", getRushCustomerRuleId())
                .append("DepartmentId", getDepartmentId())
                .append("DepartmentName", getDepartmentName())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof RushCustomerRuleDepartmentRelEntity == false) return false;
        if (this == obj) return true;
        RushCustomerRuleDepartmentRelEntity other = (RushCustomerRuleDepartmentRelEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

