/**
 * Description: HouseInfo数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-18 下午 15:44:53
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * HouseInfo数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-18
 * @see
 * @since 1.0
 */
public class HouseInfoEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 楼盘编号
     */

    private Integer houseId;

    /**
     * 楼盘名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String houseName;

    /**
     * 楼盘联系电话
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String housePhone;

    /**
     * 城市编号
     */
    private Integer cityId;

    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;

    /**
     * 是否删除 0:未删除 1:已删除
     */

    private Integer isDeleted;

    /**
     * 物业类型 1住宅2写字楼3别墅4商业5公寓
     */
    private Integer channel;

    /**
     * cityKey
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityKey;


    /**
     * 设置楼盘编号
     *
     * @param houseId 楼盘编号
     */
    public void setHouseId(Integer houseId) {
        this.houseId = houseId;
    }

    /**
     * 获取楼盘编号
     *
     * @return 楼盘编号
     */
    public Integer getHouseId() {
        return this.houseId;
    }

    /**
     * 设置楼盘名称
     *
     * @param houseName 楼盘名称
     */
    public void setHouseName(String houseName) {
        this.houseName = houseName;
    }

    /**
     * 获取楼盘名称
     *
     * @return 楼盘名称
     */
    public String getHouseName() {
        return this.houseName;
    }

    /**
     * 设置楼盘联系电话
     *
     * @param housePhone 楼盘联系电话
     */
    public void setHousePhone(String housePhone) {
        this.housePhone = housePhone;
    }

    /**
     * 获取楼盘联系电话
     *
     * @return 楼盘联系电话
     */
    public String getHousePhone() {
        return this.housePhone;
    }

    /**
     * 设置城市编号
     *
     * @param cityId 城市编号
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市编号
     *
     * @return 城市编号
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置城市名称
     *
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取城市名称
     *
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置是否删除 0:未删除 1:已删除
     *
     * @param isDeleted 是否删除 0:未删除 1:已删除
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取是否删除 0:未删除 1:已删除
     *
     * @return 是否删除 0:未删除 1:已删除
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置物业类型 1住宅2写字楼3别墅4商业5公寓
     *
     * @param channel 物业类型 1住宅2写字楼3别墅4商业5公寓
     */
    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    /**
     * 获取物业类型 1住宅2写字楼3别墅4商业5公寓
     *
     * @return 物业类型 1住宅2写字楼3别墅4商业5公寓
     */
    public Integer getChannel() {
        return this.channel;
    }

    /**
     * 设置cityKey
     *
     * @param cityKey cityKey
     */
    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    /**
     * 获取cityKey
     *
     * @return cityKey
     */
    public String getCityKey() {
        return this.cityKey;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("HouseId", getHouseId())
                .append("HouseName", getHouseName())
                .append("HousePhone", getHousePhone())
                .append("CityId", getCityId())
                .append("CityName", getCityName())
                .append("IsDeleted", getIsDeleted())
                .append("Channel", getChannel())
                .append("CityKey", getCityKey())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof HouseInfoEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HouseInfoEntity other = (HouseInfoEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

