/**
 * Description: 部门数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.google.common.base.Strings;
import com.house365.beans.common.Treeable;
import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * 部门数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public class DepartmentEntity extends DomainObject implements Treeable<DepartmentEntity> {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 部门名称
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String name;

    /**
     * url path
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String urlPath;

    /**
     * 部门类型
     */
    @Length(max = 32, message = "长度需要大于0且小于32")
    private String type;

    /**
     * 父部门
     */
    private Integer parentId;

    /**
     * 在父部门中的次序值
     */
    private Integer orderNum;

    private String fullPath;

    private Boolean root;

    private Integer hierarchy;

    private String descripition;

    /**
     * 创建时间
     */

    private java.util.Date createTime;

    /**
     * 修改时间
     */

    private java.util.Date updateTime;

    private String createTimeStr;

    private String updateTimeStr;

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public String getUpdateTimeStr() {
        return updateTimeStr;
    }

    /**
     * 设置部门名称
     *
     * @param name 部门名称
     */
    public void setName(String name) {
        this.name = name;
    }

    public Integer getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(Integer hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getDescripition() {
        return descripition;
    }

    public void setDescripition(String descripition) {
        this.descripition = descripition;
    }

    /**
     * 获取部门名称
     *
     * @return 部门名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置url path
     *
     * @param urlPath url path
     */
    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    /**
     * 获取url path
     *
     * @return url path
     */
    public String getUrlPath() {
        return this.urlPath;
    }

    /**
     * 设置部门类型
     *
     * @param type 部门类型
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取部门类型
     *
     * @return 部门类型
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置父部门
     *
     * @param parentId 父部门
     */
    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    /**
     * 获取父部门
     *
     * @return 父部门
     */
    public Integer getParentId() {
        return this.parentId;
    }

    public Integer getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置修改时间
     *
     * @param updateTime 修改时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置修改时间字符串格式
     *
     * @param updateTime 修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getFullPath() {
        return fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Boolean getRoot() {
        return root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    /**
     * 获取修改时间
     *
     * @return 修改时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 获取城市ID
     *
     * @return
     */
    public String getCityID() {
        if (Strings.isNullOrEmpty(urlPath)) {
            return "";
        }

        String cityId = "1";
        if (urlPath.split("/").length >= 3) {
            cityId = urlPath.split("/")[2];
        }

        return cityId;
    }

    public static String getCityID(String urlPath) {
        if (Strings.isNullOrEmpty(urlPath)) {
            return "";
        }

        String cityId = "1";
        if (urlPath.split("/").length >= 3) {
            cityId = urlPath.split("/")[2];
        }

        return cityId;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Name",
                getName()).append(
                "UrlPath", getUrlPath()).append("Type", getType()).append("ParentId", getParentId()).append("OrderNum",
                getOrderNum()).append(
                "CreateTime", getCreateTime()).append("UpdateTime", getUpdateTime()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DepartmentEntity == false)
            return false;
        if (this == obj)
            return true;
        DepartmentEntity other = (DepartmentEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

