/**  
 * Description: <类功能描述-必填> 公共接口，包括添加、修改、删除、通过id查询、分页查询、查询总数
 * Copyright:   Copyright (c)2012  
 * @version:    1.0  
 * Create at:   2012-12-21 下午4:22:51  
 *  
 * Modification History:  
 * Date         Author      Version     Description  
 * ------------------------------------------------------------------  
 * 
 */
package com.house365.service.system.Interfaces;

import java.util.Collection;
import java.util.List;

import com.house365.beans.system.DomainObject;
import com.house365.beans.system.QueryParams;

public interface Service<T extends DomainObject> {

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public Integer save(T entity);
    
    /**
     * 批量插入
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    public void batchSave(Collection<T> entities);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public void update(T entity);
    
    /**
     * 批量更新
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    public void batchUpdate(Collection<T> entities);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public void delete(Integer id);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public void deleteByIds(Integer... ids);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public T getById(Integer id);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public List<T> queryByPage(QueryParams<?> queryParams);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public List<T> queryAll();

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public List<T> queryAll(QueryParams<?> queryParams);

    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */
    public int getTotalCount(Object params);
    
    /**
     * {方法的功能/动作描述}
     * 
     * @param {引入参数名} {引入参数说明}
     * @return {返回参数名} {返回参数说明}
     * @exception {说明在某情况下,将发生什么异常}
     */




}
