/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: ImUtils.java
 * Author:   jiangzhou
 * Date:     2015年6月11日 上午9:09:35
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.commons.system;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.house365.web.util.MemoryPropertyPlaceholderConfigurer;

/**
 * IM发送方法
 *
 * @author jiangzhou
 * @version [v1.0.0, 2015年2月11日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class ImUtils {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ImUtils.class);

    /**
     * 
     * 调用IM发送消息接口 发送IM找房内容
     *
     * @author jiangzhou
     * @version [v1.0.0, 2015年2月11日]
     * @param msg 发送内容
     * @throws Exception
     * @since [产品/模块版本](可选)
     */
    @SuppressWarnings("rawtypes")
    public static String sendIminfo(List phonlist, String msg, String json) {
        // 调用接口返回值
        String jsonStr = "";
        String phone = "";
        // 取得IM接口URL
        String imUrl = MemoryPropertyPlaceholderConfigurer.getContextProperty("system.im.sendUrl");
        if (null == imUrl) {
            return "";
        }
        try {
            // 设置IM内容编码
            msg = URLEncoder.encode(msg, "UTF-8");
            json = URLEncoder.encode(json, "UTF-8");
            if(phonlist.size()>0){
               phone= phonlist.toString().replace("[", "").replace("]", "").replace(" ", "");
            }
            imUrl = imUrl + "&" + "ids=" + phone + "&msgmeta=" + json + "&msg=" + msg;
            URL url = new URL(imUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String line;
            while ((line = in.readLine()) != null) {
                jsonStr += line;
            }
            in.close();
        } catch (Exception e) {
            LOGGER.error("IM接口异常：发送IM失败！");
        }
        return jsonStr;
    }

}
