package com.house365.ws.util;

import com.google.common.base.Joiner;
import com.house365.beans.entity.HouseInfoEntity;
import com.house365.commons.system.HttpClientUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PhpInterfaceUtils {

    /**
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param houseId
     * @param cityKey
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年9月1日]
     * @since [产品/模块版本](可选)
     */
    public static List<HouseInfoEntity> getHouseByIds(String houseId, String cityKey, Integer channel) {
        //楼盘接口
        //http://newapi.house365.com/projects?city=nj&listid=10&channel=1
        //http://192.168.105.242/projects?channel=1&city=nj&listid=10
        //,1表示物业类型
        //http://newapi.house365.com/projects/batch?city=nj&projects=1402,1|1226,1|1344,1&idtype=listid
        List<HouseInfoEntity> houseList = new ArrayList<>();
        String urlString = "http://newapi.house365.com/projects/batch?";
        StringBuffer buffer = new StringBuffer(urlString);
        buffer.append("city=" + cityKey);
        buffer.append("&idtype=listid&projects=");
        //        buffer.append("&channel=" + channel);
        List<String> idList = Arrays.asList(houseId.split(","));
        buffer.append(Joiner.on("|").join(idList));

        // 接口地址 获取JSON字符串
        String jsonStr = "";
        try {
            jsonStr = HttpClientUtil.getJsonData(buffer.toString());
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

        System.out.println("=json==" + jsonStr);
        JSONObject json = JSONObject.fromObject(jsonStr);
        if (json.get("data") != null && !((JSONObject) json.get("data")).get("list").equals(JSONNull.getInstance()) && ((JSONObject) json.get("data")).get("list") != null) {
            JSONArray list = (JSONArray) ((JSONObject) json.get("data")).get("list");

            for (Object object : list) {
                JSONObject house = (JSONObject) object;

                //entity.setHouseName((String)house.get("itemname"));
                HouseInfoEntity houseEntity2 = new HouseInfoEntity();
                houseEntity2.setChannel(Integer.parseInt(String.valueOf(house.get("channel"))));
                houseEntity2.setHouseId(Integer.parseInt(String.valueOf(house.get("listid"))));
                houseEntity2.setHouseName((String) house.get("itemname"));
                houseEntity2.setHousePhone((String) house.get("mobiletelephone"));
                houseEntity2.setCityKey((String) house.get("city"));
                houseEntity2.setCityName((String) house.get("city_name"));
                houseEntity2.setIsDeleted(0);

                houseList.add(houseEntity2);
            }

        }

        return houseList;
    }

    public static void main(String[] args) {
        getHouseByIds("1402|1226|1344", "nj", 1);
    }

}
