/**
 * Description: StatusSourceStatistics业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-11-02 下午 17:54:57
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.UserSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.Interfaces.Service;
import com.house365.beans.entity.StatusSourceStatisticsEntity;

import java.util.List;
import java.util.Map;

/**
 * StatusSourceStatistics业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
public interface IStatusSourceStatisticsService<T extends StatusSourceStatisticsEntity> extends Service<T> {
    List<Map> statisticStatusSourceByWeek(QueryParams<T> queryParams);

    List<Map> statisticStatusSourceByMonth(QueryParams<T> queryParams);

    void updateNames();

    void deleteByDate(String startDateStr);

    List<Map> statisticCustomer(QueryParams para);

    List<Map> statisticCustomerByWeek(QueryParams<T> queryParams);

    List<Map> statisticCustomerByMonth(QueryParams<T> queryParams);

    List<Map> statisticStatusSource(QueryParams<StatusSourceStatisticsEntity> queryParams);


}
