/**
 * Description: 营销日报业务接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 下午 13:27:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.ReportMarketingEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.ReportMarketingFormVo;
import com.house365.service.system.Interfaces.Service;

import java.util.Date;
import java.util.List;

/**
 * 直销日报业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface IReportMarketingService<T extends ReportMarketingEntity> extends Service<T> {
    /**
     * 获取当月月报日历
     *
     * @param startTime 月报起始时间
     * @param endTime   月报结束时间
     * @param city
     * @param userIds
     * @return 已填写日报日期
     */
    List<ReportDailyPo> getDailies(String startTime, String endTime, String city, List<Integer> userIds);

    List<ReportMarketingEntity> getByUserId(Integer userId,String createTime);

    void updateByUserId(ReportMarketingEntity reportmarketingentity);

    List<ReportMarketingFormVo> statistic(QueryParams<?> queryParams);
}