/**
 * Description: 权限业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.WeChatPermissionEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IWeChatPermissionDao;
import com.house365.ws.service.interfaces.IWeChatPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 权限业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("weChatPermissionService")
public class WeChatPermissionServiceImpl<T extends WeChatPermissionEntity> extends DefaultServiceImpl<T> implements IWeChatPermissionService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IWeChatPermissionDao<T> weChatPermissionDao;

    @Override
    protected Dao<T> getDao() {
        return weChatPermissionDao;
    }

    @Override
    public List<WeChatPermissionEntity> getPermissionsByUserId(Integer userId) {
        return weChatPermissionDao.getPermissionsByUserId(userId);
    }

    @Override
    public List<WeChatPermissionEntity> queryAllByOrder() {
        return weChatPermissionDao.queryAllByOrder();
    }

    @Override
    public List<WeChatPermissionEntity> getPermissionsByParentId(Integer parentId) {
        return weChatPermissionDao.getPermissionsByParentId(parentId);
    }
}