/**
 * Description: BaseTree业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-08 下午 15:16:07
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-08   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.BaseTreeEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IBaseTreeDao;
import com.house365.ws.service.interfaces.IBaseTreeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * BaseTree业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-08
 * @see
 * @since 1.0
 */
@Service("baseTreeService")
public class BaseTreeServiceImpl<T extends BaseTreeEntity> extends DefaultServiceImpl<T> implements IBaseTreeService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IBaseTreeDao<T> baseTreeDao;

    @Override
    protected Dao<T> getDao() {
        return baseTreeDao;
    }

    @Override
    public List<BaseTreeEntity> findChildrenListByPath(List<T> parents) {
        return baseTreeDao.findChildrenListByPath(parents);
    }

    @Override
    public void clean(String sourceType) {
        baseTreeDao.clean(sourceType);
    }


}
