package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.house365.beans.entity.DictionaryEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.web.util.StringUtils;
import com.house365.ws.interfaces.server.IDictionary;
import com.house365.ws.service.interfaces.IDictionaryService;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>Title: 更新保护期 </p>
 * <p>Description: </p>
 * <p>Date: 16/9/15</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("updateProtectDays")
public class updateProtectDays implements IUpdateProtectDays {
    private static final Logger LOGGER = LoggerFactory.getLogger("sysLog");

    private static final String DIC = "customer.protect.days";

    @Autowired
    private IDictionaryService dictionaryService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<UserEntity> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            House365RestObject<UserEntity> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage());
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<UserEntity> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<UserEntity> restObject = null;

        String period = getMapValueByKey("period", map, "");
        String city = getMapValueByKey("city", map, "");

        Map<String, Object> queryMap = new HashMap<>(10);
        if (!Strings.isNullOrEmpty(city) && !Strings.isNullOrEmpty(period) && StringUtils.isNumeric(
            period) && Integer.parseInt(period) >= 0) {
            restObject = new House365RestObject<>();
            queryMap.put("EQ_dicKey", DIC);
            queryMap.put("EQ_city", city);
            QueryParams queryParams = new QueryParams();
            queryParams.setSearchParams(queryMap);
            List dics = dictionaryService.queryAll(queryParams);

            if (dics != null && !dics.isEmpty()) {
                DictionaryEntity dic = (DictionaryEntity) dics.get(0);
                if (dic != null && !period.equalsIgnoreCase(dic.getDicValue())) {
                    dic.setDicValue(period);
                    dictionaryService.update(dic);
                }

            } else {
                DictionaryEntity dic = new DictionaryEntity();
                dic.setDicKey(DIC);
                dic.setCity(city);
                dic.setDicValue(period);
                dic.setDicName(DIC);
                dictionaryService.save(dic);
            }

        } else {
            LOGGER.error("parameter validator error: {},{}", period, city);
            throw new Exception("parameter validator fail!");
        }

        return restObject;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
        Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
