package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CustomerProjectEntity;
import com.house365.beans.entity.ProjectEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.dao.mapper.CustomerProjectMapper;
import com.house365.ws.dao.mapper.ProjectMapper;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 清洗customer_project表中contract字段
 *
 * @author Created by Administrator on 2019/12/5.
 */
@Component("updateCodeTask")
public class UpdateCodeTaskImpl implements IUpdateCodeTaskInterface {

    private Logger logger = LoggerFactory.getLogger(UpdateCustomerStatusImpl.class);

    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private CustomerProjectMapper mapper;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        House365RestResponse<CustomerProjectEntity> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            Map<String, Object> map = new HashMap<>(5);
            List<ProjectEntity> list = projectMapper.queryByConditions(map);
            if (CollectionUtils.isNotEmpty(list)) {
                for (ProjectEntity p : list) {
                    int projectId = p.getId();
                    String contract = p.getContractCode();
                    if (StringUtils.isNotBlank(contract)) {
                        Map<String, Object> updateMap = new HashMap<>(10);
                        updateMap.put("projectId", projectId);
                        updateMap.put("contract", contract);
                        updateMap.put("updateTime", new Date());
                        mapper.updateNameAndCode(updateMap);
                    }
                }
            }
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        return JSONObject.fromObject(response).toString();
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
