package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.ProjectEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.dao.mapper.ProjectMapper;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 获取项目列表接口
 *
 * @author Created by Administrator on 2020/4/14.
 */
@Service("getProjectList")
public class GetProjectListImpl implements IGetProjectList {

    private static final Logger logger = LoggerFactory.getLogger(GetProjectListImpl.class);

    @Autowired
    private ProjectMapper mapper;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        House365RestResponse<Map<String, Object>> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            Map<String, Object> paramhMap = parameter.getArgs();
            if (paramhMap.get("city") != null && StringUtils.isNotBlank(paramhMap.get("city").toString())) {
                String city = getMapValueByKey("city", paramhMap, "");
                Map<String, Object> queryMap = new HashMap<>(5);
                List<ProjectEntity> list;
                List<String> cityList = new ArrayList<>();
                if (city.contains(",")) {
                    String[] citys = city.split(",");
                    for (String s : citys) {
                        cityList.add(s);
                    }
                    queryMap.put("cityList", cityList);
                    list = mapper.queryByConditions(queryMap);
                } else {
                    queryMap.put("city", city);
                    list = mapper.queryByConditions(queryMap);
                }
                List<Map<String, Object>> resultList = new ArrayList<>();
                House365RestObject<Map<String, Object>> restObject = new House365RestObject<>();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (ProjectEntity p : list) {
                        //城市 项目名称，关联楼盘，楼盘ID，物业类型，状态
                        Map<String, Object> map = new HashMap<>(10);
                        map.put("city", p.getCity());
                        map.put("cityName", p.getCityName());
                        map.put("projectName", p.getProjectName());
                        map.put("buildingId", p.getBuildingId());
                        map.put("buildingName", p.getBuildingName());
                        map.put("channel", p.getType());
                        map.put("showStatus", p.getShowStatus());
                        resultList.add(map);
                    }
                    restObject.setTotal(String.valueOf(list.size()));
                }

                restObject.setList(resultList);
                response.setData(restObject);
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            } else {
                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
                response.setMsg("请填写城市参数");
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.error("获取项目列表接口失败", e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        return JSONObject.fromObject(response).toString();
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
