/**
 * Description: UserSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:36:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.UserSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.UserSourceStatisticsListRequest;
import com.house365.ws.beans.request.UserSourceStatisticsRequest;
import com.house365.ws.beans.response.SourceStatisticsListResponse;
import com.house365.ws.beans.response.UserSourceStatisticsListResponse;
import com.house365.ws.beans.response.UserSourceStatisticsResponse;
import com.house365.ws.interfaces.server.IUserSourceStatistics;
import com.house365.ws.service.interfaces.IUserSourceStatisticsService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * UserSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Service("userSourceStatistics")
public class UserSourceStatisticsImpl implements IUserSourceStatistics {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSourceStatisticsImpl.class);

    /**
     * UserSourceStatistics服务对象
     */
    @Autowired
    private IUserSourceStatisticsService<UserSourceStatisticsEntity> userSourceStatisticsService;


    /**
     * UserSourceStatistics列表查询
     *
     * @param request UserSourceStatistics列表查询请求
     * @return UserSourceStatistics列表查询响应
     */
    @Override
    public UserSourceStatisticsListResponse getUserSourceStatisticsList(UserSourceStatisticsListRequest request) {
        UserSourceStatisticsListResponse response = new UserSourceStatisticsListResponse();
        try {
            QueryParams<UserSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<UserSourceStatisticsEntity> userSourceStatisticss = userSourceStatisticsService.queryByPage(
                    queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(userSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存UserSourceStatistics
     *
     * @param request UserSourceStatistics请求
     * @return 保存UserSourceStatistics响应
     */
    @Override
    public UserSourceStatisticsResponse addUserSourceStatistics(UserSourceStatisticsRequest request) {
        UserSourceStatisticsResponse response = new UserSourceStatisticsResponse();
        try {
            UserSourceStatisticsEntity entity = request.getEntity();
            userSourceStatisticsService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除UserSourceStatistics通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除UserSourceStatistics响应
     */
    @Override
    public UserSourceStatisticsResponse deleteUserSourceStatisticsById(Integer id) {
        UserSourceStatisticsResponse response = new UserSourceStatisticsResponse();
        try {
            userSourceStatisticsService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改UserSourceStatistics
     *
     * @param request 修改UserSourceStatistics请求
     * @return 修改UserSourceStatistics响应
     */
    @Override
    public UserSourceStatisticsResponse updateUserSourceStatistics(UserSourceStatisticsRequest request) {
        UserSourceStatisticsResponse response = new UserSourceStatisticsResponse();
        try {
            userSourceStatisticsService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取UserSourceStatistics
     *
     * @param id 唯一标识
     * @return 通过ID获取UserSourceStatistics响应
     */
    @Override
    public UserSourceStatisticsResponse getUserSourceStatisticsById(Integer id) {
        UserSourceStatisticsResponse response = new UserSourceStatisticsResponse();
        try {
            UserSourceStatisticsEntity entity = userSourceStatisticsService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 客户转化分析
     *
     * @param request
     * @param dateViewType
     * @return
     */
    @Override
    public SourceStatisticsListResponse customerTrans(UserSourceStatisticsListRequest request, String dateViewType) {
        SourceStatisticsListResponse response = new SourceStatisticsListResponse();
        try {
            QueryParams<UserSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());

            List<Map> projectSourceStatisticss = new ArrayList<>();
            if ("1".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = userSourceStatisticsService.transCustomer(queryParams);
            } else if ("2".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = userSourceStatisticsService.transCustomerByWeek(queryParams);
            } else if ("3".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = userSourceStatisticsService.transCustomerByMonth(queryParams);
            }

            response.setPaging(queryParams.getPaging());
            response.setObjectList(projectSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 获取客户分析统计信息
     *
     * @param request
     * @param dateViewType 1日视图2周视图3月视图
     * @return
     */
    @Override
    public SourceStatisticsListResponse statisticCustomer(
            UserSourceStatisticsListRequest request, String dateViewType
    ) {
        SourceStatisticsListResponse response = new SourceStatisticsListResponse();
        try {
            QueryParams<UserSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());

            List<Map> projectSourceStatisticss = new ArrayList<>();
            if ("1".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = userSourceStatisticsService.statisticCustomer(queryParams);
            } else if ("2".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = userSourceStatisticsService.statisticCustomerByWeek(queryParams);
            } else if ("3".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = userSourceStatisticsService.statisticCustomerByMonth(queryParams);
            }

            for (Map map : projectSourceStatisticss) {
                BigDecimal curData = map.get("customerNum") == null ? BigDecimal.ZERO : new BigDecimal(
                        String.valueOf(map.get("customerNum")));
                BigDecimal preData = map.get("prenum") == null ? BigDecimal.ZERO : new BigDecimal(
                        String.valueOf(map.get("prenum")));
                if (preData.compareTo(BigDecimal.ZERO) <= 0) {
                    map.put("huanbi", "-");
                } else {
                    BigDecimal huanbi = curData.subtract(preData).divide(preData, 4, BigDecimal.ROUND_HALF_UP);
                    if (huanbi.compareTo(BigDecimal.ZERO) == 0) {
                        map.put("huanbi", "-");
                    } else {
                        map.put("huanbi", huanbi.multiply(new BigDecimal(100)).setScale(2) + "%");
                    }
                }
            }

            response.setObjectList(projectSourceStatisticss);
            response.setPaging(queryParams.getPaging());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
